/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisShaderTypes;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisTerrainPass;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderBindingContextExt;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class IrisChunkProgramOverrides {
    private boolean shadersCreated = false;
    private final EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> programs = new EnumMap(IrisTerrainPass.class);
    private int versionCounterForSodiumShaderReload = -1;

    private GlShader createVertexShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowVertexShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            optional = sodiumTerrainPipeline.getTerrainSolidVertexShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainCutoutVertexShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentVertexShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(ShaderType.VERTEX, new class_2960("iris", "sodium-terrain-" + irisTerrainPass.toString().toLowerCase(Locale.ROOT) + ".vsh"), string);
    }

    private GlShader createGeometryShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowGeometryShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            optional = sodiumTerrainPipeline.getTerrainSolidGeometryShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainCutoutGeometryShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentGeometryShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(IrisShaderTypes.GEOMETRY, new class_2960("iris", "sodium-terrain-" + irisTerrainPass.toString().toLowerCase(Locale.ROOT) + ".gsh"), string);
    }

    private GlShader createFragmentShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        Optional<String> optional;
        if (irisTerrainPass == IrisTerrainPass.SHADOW) {
            optional = sodiumTerrainPipeline.getShadowFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            optional = sodiumTerrainPipeline.getShadowCutoutFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            optional = sodiumTerrainPipeline.getTerrainSolidFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            optional = sodiumTerrainPipeline.getTerrainCutoutFragmentShaderSource();
        } else if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            optional = sodiumTerrainPipeline.getTranslucentFragmentShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
        }
        String string = optional.orElse(null);
        if (string == null) {
            return null;
        }
        return new GlShader(ShaderType.FRAGMENT, new class_2960("iris", "sodium-terrain-" + irisTerrainPass.toString().toLowerCase(Locale.ROOT) + ".fsh"), string);
    }

    private BlendModeOverride getBlendOverride(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            return sodiumTerrainPipeline.getShadowBlendOverride();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            return sodiumTerrainPipeline.getTerrainSolidBlendOverride();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            return sodiumTerrainPipeline.getTerrainCutoutBlendOverride();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            return sodiumTerrainPipeline.getTranslucentBlendOverride();
        }
        throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
    }

    private List<BufferBlendOverride> getBufferBlendOverride(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            return sodiumTerrainPipeline.getShadowBufferOverrides();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            return sodiumTerrainPipeline.getTerrainSolidBufferOverrides();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            return sodiumTerrainPipeline.getTerrainCutoutBufferOverrides();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            return sodiumTerrainPipeline.getTranslucentBufferOverrides();
        }
        throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GlProgram<IrisChunkShaderInterface> createShader(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline, ChunkVertexType chunkVertexType) {
        GlShader glShader = this.createVertexShader(irisTerrainPass, sodiumTerrainPipeline);
        GlShader glShader2 = this.createGeometryShader(irisTerrainPass, sodiumTerrainPipeline);
        GlShader glShader3 = this.createFragmentShader(irisTerrainPass, sodiumTerrainPipeline);
        BlendModeOverride blendModeOverride = this.getBlendOverride(irisTerrainPass, sodiumTerrainPipeline);
        List<BufferBlendOverride> list = this.getBufferBlendOverride(irisTerrainPass, sodiumTerrainPipeline);
        float f = this.getAlphaReference(irisTerrainPass, sodiumTerrainPipeline);
        if (glShader == null || glShader3 == null) {
            if (glShader != null) {
                glShader.delete();
            }
            if (glShader2 != null) {
                glShader2.delete();
            }
            if (glShader3 != null) {
                glShader3.delete();
            }
            return null;
        }
        try {
            GlProgram.Builder builder = GlProgram.builder((class_2960)new class_2960("sodium", "chunk_shader_for_" + irisTerrainPass.getName()));
            if (glShader2 != null) {
                builder.attachShader(glShader2);
            }
            GlProgram glProgram = builder.attachShader(glShader).attachShader(glShader3).bindAttribute("a_PosId", 1).bindAttribute("a_Color", 2).bindAttribute("a_TexCoord", 3).bindAttribute("a_LightCoord", 4).bindAttribute("mc_Entity", 11).bindAttribute("mc_midTexCoord", 12).bindAttribute("at_tangent", 13).bindAttribute("iris_Normal", 10).bindAttribute("at_midBlock", 14).link(shaderBindingContext -> {
                int n = ((GlObject)shaderBindingContext).handle();
                ShaderBindingContextExt shaderBindingContextExt = (ShaderBindingContextExt)shaderBindingContext;
                return new IrisChunkShaderInterface(n, shaderBindingContextExt, sodiumTerrainPipeline, new ChunkShaderOptions(ChunkFogMode.SMOOTH, irisTerrainPass.toTerrainPass()), irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT, blendModeOverride, list, f, sodiumTerrainPipeline.getCustomUniforms());
            });
            return glProgram;
        }
        finally {
            glShader.delete();
            if (glShader2 != null) {
                glShader2.delete();
            }
            glShader3.delete();
        }
    }

    private float getAlphaReference(IrisTerrainPass irisTerrainPass, SodiumTerrainPipeline sodiumTerrainPipeline) {
        if (irisTerrainPass == IrisTerrainPass.SHADOW || irisTerrainPass == IrisTerrainPass.SHADOW_CUTOUT) {
            return sodiumTerrainPipeline.getShadowAlpha().orElse(AlphaTests.ONE_TENTH_ALPHA).getReference();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_SOLID) {
            return AlphaTest.ALWAYS.getReference();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_CUTOUT) {
            return sodiumTerrainPipeline.getTerrainCutoutAlpha().orElse(AlphaTests.ONE_TENTH_ALPHA).getReference();
        }
        if (irisTerrainPass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            return sodiumTerrainPipeline.getTranslucentAlpha().orElse(AlphaTest.ALWAYS).getReference();
        }
        throw new IllegalArgumentException("Unknown pass type " + irisTerrainPass);
    }

    private SodiumTerrainPipeline getSodiumTerrainPipeline() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            return worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        return null;
    }

    public void createShaders(SodiumTerrainPipeline sodiumTerrainPipeline, ChunkVertexType chunkVertexType) {
        if (sodiumTerrainPipeline != null) {
            sodiumTerrainPipeline.patchShaders(chunkVertexType);
            for (IrisTerrainPass irisTerrainPass : IrisTerrainPass.values()) {
                if (irisTerrainPass.isShadow() && !sodiumTerrainPipeline.hasShadowPass()) {
                    this.programs.put(irisTerrainPass, null);
                    continue;
                }
                this.programs.put(irisTerrainPass, this.createShader(irisTerrainPass, sodiumTerrainPipeline, chunkVertexType));
            }
        } else {
            for (GlProgram<IrisChunkShaderInterface> glProgram : this.programs.values()) {
                if (glProgram == null) continue;
                glProgram.delete();
            }
            this.programs.clear();
        }
        this.shadersCreated = true;
    }

    @Nullable
    public GlProgram<IrisChunkShaderInterface> getProgramOverride(TerrainRenderPass terrainRenderPass, ChunkVertexType chunkVertexType) {
        if (this.versionCounterForSodiumShaderReload != Iris.getPipelineManager().getVersionCounterForSodiumShaderReload()) {
            this.versionCounterForSodiumShaderReload = Iris.getPipelineManager().getVersionCounterForSodiumShaderReload();
            this.deleteShaders();
        }
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        SodiumTerrainPipeline sodiumTerrainPipeline = null;
        if (worldRenderingPipeline != null) {
            sodiumTerrainPipeline = worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        if (!this.shadersCreated) {
            this.createShaders(sodiumTerrainPipeline, chunkVertexType);
        }
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (sodiumTerrainPipeline != null && !sodiumTerrainPipeline.hasShadowPass()) {
                throw new IllegalStateException("Shadow program requested, but the pack does not have a shadow pass?");
            }
            if (terrainRenderPass.supportsFragmentDiscard()) {
                return this.programs.get((Object)IrisTerrainPass.SHADOW_CUTOUT);
            }
            return this.programs.get((Object)IrisTerrainPass.SHADOW);
        }
        if (terrainRenderPass.supportsFragmentDiscard()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_CUTOUT);
        }
        if (terrainRenderPass.isReverseOrder()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_TRANSLUCENT);
        }
        return this.programs.get((Object)IrisTerrainPass.GBUFFER_SOLID);
    }

    public void bindFramebuffer(TerrainRenderPass terrainRenderPass) {
        GlFramebuffer glFramebuffer;
        SodiumTerrainPipeline sodiumTerrainPipeline = this.getSodiumTerrainPipeline();
        boolean bl = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        if (sodiumTerrainPipeline != null && (glFramebuffer = bl ? sodiumTerrainPipeline.getShadowFramebuffer() : (terrainRenderPass.isReverseOrder() ? sodiumTerrainPipeline.getTranslucentFramebuffer() : sodiumTerrainPipeline.getTerrainSolidFramebuffer())) != null) {
            glFramebuffer.bind();
        }
    }

    public void unbindFramebuffer() {
        SodiumTerrainPipeline sodiumTerrainPipeline = this.getSodiumTerrainPipeline();
        if (sodiumTerrainPipeline != null) {
            class_310.method_1551().method_1522().method_1235(false);
        }
    }

    public void deleteShaders() {
        for (GlProgram<IrisChunkShaderInterface> glProgram : this.programs.values()) {
            if (glProgram == null) continue;
            glProgram.delete();
        }
        this.programs.clear();
        this.shadersCreated = false;
    }
}

