/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import org.embeddedt.modernfix.ModernFix;

public enum BakeReason {
    FREEZE,
    REMOTE_SNAPSHOT_INJECT,
    LOCAL_SNAPSHOT_INJECT,
    REVERT,
    UNKNOWN;

    private static BakeReason currentBakeReason;
    private static boolean bakeReasonWarned;

    public static BakeReason getCurrentBakeReason() {
        if (currentBakeReason == null && !bakeReasonWarned) {
            ModernFix.LOGGER.warn("No bake reason found, mixin probably not applied correctly", (Throwable)new IllegalStateException());
            bakeReasonWarned = false;
        }
        return currentBakeReason;
    }

    public static void setCurrentBakeReason(BakeReason reason) {
        currentBakeReason = reason;
    }

    static {
        currentBakeReason = null;
        bakeReasonWarned = false;
    }
}

