/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.pipes.normal.plastic;

import com.drmangotea.tfmg.blocks.pipes.normal.LockablePipeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlasticPipeBlock
extends FluidPipeBlock {
    public PlasticPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, BlockAndTintGetter world, BlockPos pos) {
        if (world.m_7702_(pos) instanceof LockablePipeBlockEntity && ((LockablePipeBlockEntity)world.m_7702_((BlockPos)pos)).locked) {
            return state;
        }
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(f_55154_::get).filter(arg_0 -> ((BlockState)prevState).m_61143_(arg_0)).count();
        for (Direction d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = PlasticPipeBlock.canConnectTo((BlockAndTintGetter)world, (BlockPos)pos.m_121945_(d), (BlockState)world.m_8055_(pos.m_121945_(d)), (Direction)d);
            if (world.m_7702_(pos.m_121945_(d)) instanceof LockablePipeBlockEntity && ((LockablePipeBlockEntity)world.m_7702_((BlockPos)pos.m_121945_((Direction)d))).locked) {
                shouldConnect = false;
                if (((Boolean)world.m_8055_(pos.m_121945_(d)).m_61143_((Property)f_55154_.get(d.m_122424_()))).booleanValue()) {
                    shouldConnect = true;
                }
            }
            state = (BlockState)state.m_61124_((Property)f_55154_.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!PlasticPipeBlock.isOpenAt((BlockState)state, (Direction)d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.m_61124_((Property)f_55154_.get(connectedDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)f_55154_.get(preferredDirection), (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55154_.get(preferredDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        super.m_213897_(state, world, pos, r);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        Direction.Axis axis = this.getAxis((BlockGetter)world, pos, state);
        if (axis == null) {
            Vec3 clickLocation = context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vec3 centerOf;
                double distance;
                if (clickedFace.m_122434_() == direction.m_122434_() || !((distance = (centerOf = Vec3.m_82512_((Vec3i)direction.m_122436_())).m_82557_(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.m_122434_();
        }
        if (clickedFace.m_122434_() == axis) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            this.withBlockEntityDo((BlockGetter)world, pos, fpte -> ((FluidTransportBehaviour)fpte.getBehaviour((BehaviourType)FluidTransportBehaviour.TYPE)).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.m_43723_())));
            FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
            world.m_46597_(pos, (BlockState)((BlockState)TFMGBlocks.GLASS_PLASTIC_PIPE.getDefaultState().m_61124_((Property)GlassFluidPipeBlock.f_55923_, (Comparable)axis)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))));
            FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private Direction.Axis getAxis(BlockGetter world, BlockPos pos, BlockState state) {
        return FluidPropagator.getStraightPipeAxis((BlockState)state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return TFMGBlocks.PLASTIC_PIPE.asStack();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!AllBlocks.COPPER_CASING.isIn(player.m_21120_(hand))) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        world.m_46597_(pos, EncasedPipeBlock.transferSixWayProperties((BlockState)state, (BlockState)TFMGBlocks.COPPER_ENCASED_PLASTIC_PIPE.getDefaultState()));
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.LOCKABLE_PIPE.get();
    }
}

