/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework.handler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.ServerPlayHelper;
import com.mrcrayfish.configured.platform.Services;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.ConfigType;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.framework.network.message.play.S2CSyncConfigData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class FrameworkServerHandler {
    public static void handleServerSync(ServerPlayer player, MessageFramework.Sync message, Consumer<Component> disconnect) {
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        Constants.LOG.debug("Received Framework server config sync from player: {}", (Object)player.m_7755_().getString());
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("Client sent data for a config that doesn't exist: {}", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.isReadOnly()) {
            Constants.LOG.error("Client sent data for a read-only config '{}'", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Constants.LOG.error("Client sent data for a config is not supposed to be updated '{}'", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Constants.LOG.error("Client tried to perform sync update on an unloaded config. Something went wrong...");
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (FrameworkServerHandler.processSyncData(message, true)) {
            if (config.getType().isSync()) {
                Network.getPlayChannel().sendToAll((IMessage)new S2CSyncConfigData(message.id(), message.data()));
            }
            ServerPlayHelper.sendMessageToOperators((Component)Component.m_237110_((String)"configured.chat.config_updated", (Object[])new Object[]{player.m_7755_(), config.getFileName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), player);
        } else {
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
        }
    }

    private static boolean processSyncData(MessageFramework.Sync message, boolean server) {
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("No Framework config exists for the id: {}", (Object)message.id());
            return false;
        }
        if (server) {
            if (!config.getType().isServer()) {
                Constants.LOG.error("Received sync update for incorrect Framework config: {}", (Object)message.id());
                return false;
            }
        } else if (!config.getType().isSync()) {
            Constants.LOG.error("Received sync update for a non-sync Framework config: {}", (Object)message.id());
            return false;
        }
        if (config.isReadOnly() || !config.isLoaded()) {
            Constants.LOG.error("Received sync update for incorrect Framework config: {}", (Object)message.id());
            return false;
        }
        try {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            if (!config.isCorrect((UnmodifiableConfig)data)) {
                Constants.LOG.error("Received incorrect Framework config data");
                return false;
            }
            UnmodifiableConfig unmodifiableConfig = config.getConfig();
            if (unmodifiableConfig instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.putAll((UnmodifiableConfig)data);
                config.getAllProperties().forEach(AbstractProperty::invalidateCache);
                ((FrameworkConfigEvents.Reload)FrameworkConfigEvents.RELOAD.post()).handle(config.getSource());
                Constants.LOG.debug("Successfully processed sync update for Framework config: {}", (Object)message.id());
                return true;
            }
        }
        catch (ParsingException e) {
            Constants.LOG.error("Received malformed Framework config data", (Throwable)e);
        }
        catch (Exception e) {
            Constants.LOG.error("An exception was thrown when processing Framework config data", (Throwable)e);
        }
        return false;
    }

    public static void handleRequestConfig(ServerPlayer player, MessageFramework.Request message, Consumer<Component> disconnect) {
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        Constants.LOG.debug("Received Framework config request from player: {}", (Object)player.m_7755_().getString());
        FrameworkConfigManager.FrameworkConfigImpl config = FrameworkConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Constants.LOG.error("Client tried requesting a Framework config that doesn't exist: {}", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType().isSync() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Constants.LOG.error("Client tried requesting a Framework config that is not allowed to be requested: '{}'", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Constants.LOG.error("The Framework config '{}' the client was requesting is not loaded. Something went terribly wrong...", (Object)message.id());
            disconnect.accept((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TomlFormat.instance().createWriter().write(config.getConfig(), (OutputStream)stream);
        Services.PLATFORM.sendFrameworkConfigResponse(player, stream.toByteArray());
    }
}

