/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.mixin;

import com.hidoni.customizableelytra.client.CustomizableElytraLayerHelper;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.render.ElytraWingModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public abstract class ElytraLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ElytraModel<T> f_116935_;
    private ElytraWingModel<T> leftWing;
    private ElytraWingModel<T> rightWing;
    private CustomizableElytraLayerHelper<T> helper;

    public ElytraLayerMixin(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initWingModels(RenderLayerParent<T, M> parent, EntityModelSet entityModelSet, CallbackInfo ci) {
        this.leftWing = new ElytraWingModel<T>(this.f_116935_, false);
        this.rightWing = new ElytraWingModel<T>(this.f_116935_, true);
        this.helper = new CustomizableElytraLayerHelper();
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    private void storeRenderArguments(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.helper.setEntity(livingEntity);
        this.helper.setDefaultBuffer(buffer);
    }

    @ModifyVariable(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at=@At(value="STORE"), ordinal=0)
    private ItemStack storeElytraStack(ItemStack elytra) {
        this.helper.setElytra(elytra);
        return elytra;
    }

    @Redirect(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"))
    private void renderCustomizedElytraWings(ElytraModel<T> elytraModel, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int overlayTexture, float red, float green, float blue, float alpha) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(this.helper.getElytra());
        if (!customization.isCustomized()) {
            elytraModel.m_7695_(poseStack, vertexConsumer, packedLight, overlayTexture, red, green, blue, alpha);
            return;
        }
        this.m_117386_().m_102624_(this.leftWing);
        this.m_117386_().m_102624_(this.rightWing);
        this.helper.renderWing(this.leftWing, customization.leftWing(), poseStack, vertexConsumer, packedLight, this.helper.getElytra().m_41790_());
        this.helper.renderWing(this.rightWing, customization.rightWing(), poseStack, vertexConsumer, packedLight, this.helper.getElytra().m_41790_());
    }
}

