/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.compat.jei.BasinFermentingStationElement;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class BasinFermentingCategory
extends CreateRecipeCategory<BasinRecipe> {
    private final BasinFermentingStationElement BasinFermentingStation = new BasinFermentingStationElement();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public BasinFermentingCategory(CreateRecipeCategory.Info<BasinRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BasinRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Pair pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).m_43908_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 41 - i / 3 * 19).setBackground(BasinFermentingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 41 - i / 3 * 19).setBackground(BasinFermentingCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, BasinFermentingCategory.withImprovedVisibility((List)fluidIngredient.getMatchingFluidStacks()))).addTooltipCallback(BasinFermentingCategory.addFluidTooltip((int)fluidIngredient.getRequiredAmount()));
            ++i;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(BasinFermentingCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addTooltipCallback(BasinFermentingCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(BasinFermentingCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)BasinFermentingCategory.withImprovedVisibility((FluidStack)fluidResult))).addTooltipCallback(BasinFermentingCategory.addFluidTooltip((int)fluidResult.getAmount()));
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 81).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 20);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeat ? 10 : 30));
        this.BasinFermentingStation.draw(graphics, 91, 47);
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, 91, 55);
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Lang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 86, requiredHeat.getColor(), false);
    }
}

