/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackCrankBlockEntity;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class PumpjackCrankRenderer
extends ShaftRenderer<PumpjackCrankBlockEntity> {
    public PumpjackCrankRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PumpjackCrankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        BlockState blockState = be.m_58900_();
        BlockPos pos = be.m_58899_();
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)be.prevAngle, (double)be.angle);
        boolean isXAxis = ((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X;
        double v = (double)(((isXAxis ? angle : -angle) + 90.0f) / 180.0f) * Math.PI;
        double sin = Math.sin(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double cos = Math.cos(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        SuperByteBuffer crank = CachedBufferer.partial((PartialModel)(be.crankSize.getValue() == 0 ? PartialModels.PUMPJACK_CRANK_SMALL : PartialModels.PUMPJACK_CRANK_LARGE), (BlockState)blockState);
        SuperByteBuffer rod = CachedBufferer.partial((PartialModel)(be.crankSize.getValue() == 0 ? PartialModels.PUMPJACK_CRANK_ROD_SMALL : PartialModels.PUMPJACK_CRANK_ROD_LARGE), (BlockState)blockState);
        if (be.bearingPos == null) {
            if (isXAxis) {
                crank.translate(0.5, 1.25, 0.0).rotateZ((double)angle);
            } else {
                ((SuperByteBuffer)crank.translate(0.0, 1.25, 0.5).rotateY(90.0)).rotateZ((double)angle);
            }
            double dstY = -1000.0 - sin - 1.25 - (double)pos.m_123342_();
            double dstX = (double)pos.m_123341_() - cos - 0.5 - (double)pos.m_123341_();
            double dstZ = (double)pos.m_123343_() - cos - 0.5 - (double)pos.m_123343_();
            if (isXAxis) {
                rod.translate(0.5, 1.25, 0.0).translate(cos, sin, 0.0).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
            } else {
                ((SuperByteBuffer)rod.translate(0.0, 1.25, 0.5).translate(0.0, sin, cos).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
            }
            rod.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            crank.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        PumpjackBearingBlockEntity bearing = (PumpjackBearingBlockEntity)((Object)be.bearing.get());
        float interpolatedAngle = 0.0f;
        if (bearing != null) {
            interpolatedAngle = bearing.getInterpolatedAngle(partialTicks);
        }
        if (!isXAxis) {
            interpolatedAngle *= -1.0f;
        }
        Vec2 crankBearingLocation = new Vec2((float)(be.crankBearingLocation.f_82479_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI) - be.crankBearingLocation.f_82480_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f, (float)(be.crankBearingLocation.f_82479_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI) + be.crankBearingLocation.f_82480_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f);
        crankBearingLocation = isXAxis ? crankBearingLocation.m_165910_(new Vec2((float)be.bearingPos.m_123341_(), (float)be.bearingPos.m_123342_())) : crankBearingLocation.m_165910_(new Vec2((float)be.bearingPos.m_123343_(), (float)be.bearingPos.m_123342_()));
        if (isXAxis) {
            crank.translate(0.5, 1.25, 0.0).rotateZ((double)angle);
        } else {
            ((SuperByteBuffer)crank.translate(0.0, 1.25, 0.5).rotateY(90.0)).rotateZ((double)angle);
        }
        double dstY = (double)crankBearingLocation.f_82471_ - sin - 1.25 - (double)pos.m_123342_();
        double dstX = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)pos.m_123341_();
        double dstZ = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)pos.m_123343_();
        if (isXAxis) {
            rod.translate(0.5, 1.25, 0.0).translate(cos, sin, 0.0).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
        } else {
            ((SuperByteBuffer)rod.translate(0.0, 1.25, 0.5).translate(0.0, sin, cos).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
        }
        rod.light(light);
        crank.light(light);
        rod.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        crank.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
    }
}

