/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class CanisterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    CapacityEnchantedFluidTankBehaviour tank;
    BlockState state;
    private Component customName;
    private int capacityEnchantLevel;
    private ListTag enchantmentTag;

    public CanisterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = state;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = CapacityEnchantedFluidTankBehaviour.single(this, Math.abs((Integer)ConfigRegistry.CANISTER_CAPACITY.get()), (Integer)ConfigRegistry.CANISTER_CAPACITY_ENCHANTMENT.get());
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (this.enchantmentTag != null) {
            compound.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.capacityEnchantLevel = compound.m_128451_("CapacityEnchantment");
        if (compound.m_128441_("Enchantments")) {
            this.enchantmentTag = compound.m_128437_("Enchantments", 10);
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public ListTag getEnchantmentTag() {
        return this.enchantmentTag;
    }

    public void setEnchantmentTag(ListTag enchantmentTag) {
        this.enchantmentTag = enchantmentTag;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
        this.tank.getPrimaryHandler().setCapacity(this.tank.baseCapacity + this.tank.capacityAddition * capacityEnchantLevel);
    }

    public static class CapacityEnchantedFluidTankBehaviour
    extends SmartFluidTankBehaviour {
        int capacityAddition;
        int baseCapacity;

        public CapacityEnchantedFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety, int capacityAddition) {
            super(type, be, tanks, tankCapacity, enforceVariety);
            this.capacityAddition = capacityAddition;
            this.baseCapacity = tankCapacity;
        }

        public static CapacityEnchantedFluidTankBehaviour single(SmartBlockEntity be, int capacity, int capacityAddition) {
            return new CapacityEnchantedFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)TYPE, be, 1, capacity, false, capacityAddition);
        }

        public void read(CompoundTag compound, boolean clientPacket) {
            super.read(compound, clientPacket);
            if (compound.m_128441_("CapacityEnchantment")) {
                this.getPrimaryHandler().setCapacity(this.baseCapacity + compound.m_128451_("CapacityEnchantment") * this.capacityAddition);
            }
        }
    }
}

