/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;

public enum RuneColor implements StringRepresentable
{
    WHITE(DyeColor.WHITE),
    ORANGE(DyeColor.ORANGE),
    MAGENTA(DyeColor.MAGENTA),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE),
    YELLOW(DyeColor.YELLOW),
    LIME(DyeColor.LIME),
    PINK(DyeColor.PINK),
    GRAY(DyeColor.GRAY),
    LIGHT_GRAY(DyeColor.LIGHT_GRAY),
    CYAN(DyeColor.CYAN),
    PURPLE(DyeColor.PURPLE),
    BLUE(DyeColor.BLUE),
    BROWN(DyeColor.BROWN),
    GREEN(DyeColor.GREEN),
    RED(DyeColor.RED),
    BLACK(DyeColor.BLACK, 0x404040),
    RAINBOW("rainbow", ChatFormatting.WHITE),
    BLANK("blank", ChatFormatting.GRAY);

    @Nullable
    private final DyeColor dyeColor;
    private final String name;
    private final int textColor;

    private RuneColor(DyeColor color) {
        this(color, color.m_41071_());
    }

    private RuneColor(DyeColor color, int textColor) {
        this(color.m_7912_(), textColor, color);
    }

    private RuneColor(String name, ChatFormatting textColor) {
        this(name, textColor.m_126665_() != null ? textColor.m_126665_() : -1, null);
    }

    private RuneColor(@Nullable String name, int textColor, DyeColor dyeColor) {
        this.dyeColor = dyeColor;
        this.name = name;
        this.textColor = textColor;
    }

    public TextColor getTextColor() {
        return TextColor.m_131266_((int)this.textColor);
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public static RuneColor byName(String name) {
        for (RuneColor color : RuneColor.values()) {
            if (!color.m_7912_().equals(name)) continue;
            return color;
        }
        return null;
    }

    @Nullable
    public static RuneColor byDyeColor(DyeColor dyeColor) {
        for (RuneColor color : RuneColor.values()) {
            if (color.dyeColor != dyeColor) continue;
            return color;
        }
        return null;
    }
}

