/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import xerca.xercapaint.client.RenderEntityCanvas;
import xerca.xercapaint.common.item.ItemCanvas;

@ParametersAreNonnullByDefault
public class CanvasItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation backLocation = new ResourceLocation("minecraft", "textures/block/birch_planks.png");
    private static final ResourceLocation emptyCanvasLocation = new ResourceLocation("xercapaint", "textures/block/empty.png");

    public CanvasItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModelSet) {
        super(dispatcher, entityModelSet);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Item item = stack.m_41720_();
        if (item instanceof ItemCanvas) {
            ItemCanvas itemCanvas = (ItemCanvas)item;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                RenderEntityCanvas.Instance canvasIns = RenderEntityCanvas.theInstance.getCanvasRendererInstance(nbt, itemCanvas.getWidth(), itemCanvas.getHeight());
                if (canvasIns != null) {
                    canvasIns.render(null, 0.0f, 0.0f, matrixStack, buffer, Direction.UP, combinedLight);
                }
            } else {
                this.renderEmptyCanvas(matrixStack, buffer, itemCanvas.getWidth(), itemCanvas.getHeight(), combinedLight);
            }
        }
    }

    private void addVertex(VertexConsumer vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
        vb.m_252986_(m, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, 255).m_7421_(tx, ty).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_252939_(mn, xOff, yOff, zOff).m_5752_();
    }

    private void renderEmptyCanvas(PoseStack ms, MultiBufferSource buffer, float width, float height, int packedLight) {
        float wScale = width / 16.0f;
        float hScale = height / 16.0f;
        ms.m_85836_();
        Matrix3f mn = ms.m_85850_().m_252943_();
        float xOffset = Direction.UP.m_122429_();
        float yOffset = Direction.UP.m_122430_();
        float zOffset = Direction.UP.m_122431_();
        ms.m_85850_().m_252943_().set((Matrix3fc)mn);
        float f = 0.03125f;
        ms.m_85837_(0.75, 0.5, 0.5);
        f = wScale > 1.0f || hScale > 1.0f ? (f /= 3.3f) : (f /= 2.0f);
        ms.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        ms.m_85841_(f, f, f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)emptyCanvasLocation);
        Matrix4f m = ms.m_85850_().m_252922_();
        mn = ms.m_85850_().m_252943_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)emptyCanvasLocation));
        this.addVertex(vb, m, mn, 0.0, 32.0f * hScale, -1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0f * wScale, 32.0f * hScale, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0f * wScale, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        vb = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)backLocation));
        float sideWidth = 0.0625f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)backLocation);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
        this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
        ms.m_85849_();
    }
}

