/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StationBlock.class}, remap=false)
public abstract class MixinStationBlock {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void autoWhistle(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, CallbackInfoReturnable<InteractionResult> cir) {
        BlockEntity blockEntity;
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (CRBlocks.CONDUCTOR_WHISTLE_FLAG.asStack().m_41720_().equals(itemInHand.m_41720_()) && !pLevel.f_46443_ && pPlayer instanceof DeployerFakePlayer && (blockEntity = pLevel.m_7702_(pPos)) instanceof StationBlockEntity) {
            StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
            cir.setReturnValue((Object)InteractionResult.CONSUME);
            GlobalStation station = stationBe.getStation();
            if (station != null && station.getPresentTrain() == null) {
                ItemStack scheduleStack;
                CompoundTag stackTag = itemInHand.m_41783_();
                if (stackTag == null || !stackTag.m_128403_("SelectedTrain") || !stackTag.m_128403_("SelectedConductor")) {
                    cir.setReturnValue((Object)InteractionResult.FAIL);
                }
                BlockPos pos = stationBe.edgePoint.getPos();
                Level level = pPlayer.m_9236_();
                UUID trainId = stackTag.m_128342_("SelectedTrain");
                UUID conductorId = stackTag.m_128342_("SelectedConductor");
                Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                    return;
                }
                boolean foundConductor = false;
                Carriage conductorCarriage = null;
                if (train == null) {
                    return;
                }
                for (Object carriage : train.carriages) {
                    if (!((ICarriageConductors)carriage).getControllingConductors().contains(conductorId)) continue;
                    foundConductor = true;
                    conductorCarriage = carriage;
                    break;
                }
                if (!foundConductor) {
                    return;
                }
                stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                stackTag.m_128473_("Bezier");
                itemInHand.m_41751_(stackTag);
                if (((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != pPlayer) {
                    stackTag.m_128473_("SelectedPos");
                    itemInHand.m_41751_(stackTag);
                    return;
                }
                if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule()).m_41619_()) {
                    for (CompoundTag passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                        ListTag schedulesList;
                        if (passengerTag.m_128441_("PlayerPassenger") || !passengerTag.m_128441_("id") || !CREntities.CONDUCTOR.getId().equals((Object)new ResourceLocation(passengerTag.m_128461_("id"))) || !passengerTag.m_128403_("UUID") || !passengerTag.m_128342_("UUID").equals(conductorId)) continue;
                        if (!passengerTag.m_128441_("heldSchedules")) {
                            schedulesList = new ListTag();
                            passengerTag.m_128365_("heldSchedules", (Tag)schedulesList);
                        } else {
                            schedulesList = passengerTag.m_128437_("heldSchedules", 10);
                        }
                        schedulesList.add((Object)scheduleStack.m_41739_(new CompoundTag()));
                        scheduleStack.m_41764_(0);
                        break;
                    }
                    if (!scheduleStack.m_41619_()) {
                        conductorCarriage.forEachPresentEntity(cce -> {
                            if (!scheduleStack.m_41619_()) {
                                for (Entity passenger : cce.m_20197_()) {
                                    if (!(passenger instanceof ConductorEntity)) continue;
                                    ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                    if (!passenger.m_20148_().equals(conductorId)) continue;
                                    conductorEntity.addSchedule(scheduleStack);
                                    scheduleStack.m_41764_(0);
                                    break;
                                }
                            }
                        });
                    }
                    if (!scheduleStack.m_41619_() && !pPlayer.m_36356_(scheduleStack)) {
                        pPlayer.m_36176_(scheduleStack, false);
                    }
                }
                Schedule schedule = new Schedule();
                ScheduleEntry entry = new ScheduleEntry();
                DestinationInstruction instruction = new DestinationInstruction();
                ScheduledDelay condition = new ScheduledDelay();
                condition.getData().m_128405_("Value", 0);
                instruction.getData().m_128359_("Text", station.name);
                entry.instruction = instruction;
                if (entry.conditions.size() == 0) {
                    entry.conditions.add(new ArrayList());
                }
                ((List)entry.conditions.get(0)).add(condition);
                schedule.entries.add(entry);
                schedule.cyclic = false;
                train.runtime.setSchedule(schedule, true);
                ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (station != null && station.getPresentTrain() != null) {
                UUID trainId = station.getPresentTrain().id;
                Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                if (train == null) {
                    return;
                }
                AtomicBoolean found = new AtomicBoolean(false);
                for (Carriage carriage : train.carriages) {
                    carriage.forEachPresentEntity(e -> e.m_146897_().forEach(p -> {
                        if (p instanceof ConductorEntity) {
                            ConductorEntity conductor = (ConductorEntity)((Object)((Object)p));
                            if (!found.get()) {
                                CompoundTag stackTag = itemInHand.m_41784_();
                                stackTag.m_128362_("SelectedTrain", train.id);
                                stackTag.m_128362_("SelectedConductor", conductor.m_20148_());
                                stackTag.m_128344_("SelectedColor", ((Byte)conductor.m_20088_().m_135370_(ConductorEntity.COLOR)).byteValue());
                                itemInHand.m_41751_(stackTag);
                                pPlayer.m_21008_(pHand, itemInHand);
                                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                                found.set(true);
                            }
                        }
                    }));
                }
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=true)
    private void deployersAssemble(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!pLevel.f_46443_ && pPlayer instanceof DeployerFakePlayer) {
            DeployerFakePlayer deployerFakePlayer = (DeployerFakePlayer)pPlayer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof StationBlockEntity) {
                StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
                cir.setReturnValue((Object)InteractionResult.CONSUME);
                GlobalStation station = stationBe.getStation();
                boolean isAssemblyMode = (Boolean)pState.m_61143_((Property)StationBlock.ASSEMBLING);
                if (station != null && station.getPresentTrain() == null) {
                    if (stationBe.isAssembling() || stationBe.tryEnterAssemblyMode()) {
                        stationBe.assemble(deployerFakePlayer.m_20148_());
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        if (isAssemblyMode) {
                            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false)), 3);
                            stationBe.refreshBlockState();
                        }
                    }
                    return;
                }
                BlockState newState = null;
                if (!isAssemblyMode) {
                    newState = (BlockState)pState.m_61124_((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
                }
                if (this.disassembleAndEnterMode((ServerPlayer)deployerFakePlayer, stationBe)) {
                    if (newState != null) {
                        pLevel.m_7731_(pPos, newState, 3);
                        stationBe.refreshBlockState();
                        stationBe.refreshAssemblyInfo();
                    }
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }

    private boolean disassembleAndEnterMode(ServerPlayer sender, StationBlockEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            ItemStack schedule;
            Train train = station.getPresentTrain();
            BlockPos trackPosition = te.edgePoint.getGlobalPosition();
            ItemStack itemStack = schedule = train == null ? ItemStack.f_41583_ : train.runtime.returnSchedule();
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.m_7494_())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(ServerPlayer sender, StationBlockEntity te, ItemStack schedule) {
        if (schedule.m_41619_()) {
            return;
        }
        if (sender.m_21205_().m_41619_()) {
            sender.m_150109_().m_150079_(schedule);
            return;
        }
        Vec3 v = VecHelper.getCenterOf((Vec3i)te.m_58899_());
        ItemEntity itemEntity = new ItemEntity(te.m_58904_(), v.f_82479_, v.f_82480_, v.f_82481_, schedule);
        itemEntity.m_20256_(Vec3.f_82478_);
        te.m_58904_().m_7967_((Entity)itemEntity);
    }
}

