/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.DoggyBlocks;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;

public class DogDistantTeleportToBedPromise
extends AbstractPromise {
    private Dog dog;
    private ServerLevel level;
    private BlockPos bedPos;
    private boolean bedChunkForced;
    private boolean dogTeleported = false;
    private int tickPersist = 5;

    public DogDistantTeleportToBedPromise(Dog dog) {
        ServerLevel sLevel;
        this.dog = dog;
        Level level = this.dog.m_9236_();
        this.level = level instanceof ServerLevel ? (sLevel = (ServerLevel)level) : null;
    }

    @Override
    public void start() {
        BlockPos bedPos0;
        if (this.level == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Optional<BlockPos> bedPosOptional = this.dog.getBedPos();
        if (!bedPosOptional.isPresent()) {
            this.rejectedMsg = "NOBEDPOSATDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.bedPos = bedPos0 = bedPosOptional.get();
        ChunkPos chunkpos = new ChunkPos(this.bedPos);
        if (this.dog.m_9236_().m_7232_(chunkpos.f_45578_, chunkpos.f_45579_)) {
            this.rejectedMsg = "ALREADYREQUESTORLOADED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.setBedChunk(true);
    }

    @Override
    public void tick() {
        if (this.dogTeleported) {
            if (--this.tickPersist <= 0) {
                this.setState(AbstractPromise.State.FULFILLED);
            }
            return;
        }
        BlockState blockState = this.level.m_8055_(this.bedPos);
        if (blockState.m_60734_() != DoggyBlocks.DOG_BED.get()) {
            this.rejectedMsg = "BEDDESTROYED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        BlockPos b1 = this.bedPos.m_7494_();
        if (!DogUtil.isTeleportSafeBlockMidAir(this.dog, b1)) {
            this.rejectedMsg = "BEDOBSTRUCTED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.dog.f_19789_ = 0.0f;
        this.dog.m_7678_((float)b1.m_123341_() + 0.5f, b1.m_123342_(), (float)b1.m_123343_() + 0.5f, this.dog.m_146908_(), this.dog.m_146909_());
        this.dog.m_21573_().m_26573_();
        this.dog.m_21839_(true);
        this.dogTeleported = true;
        this.tickPersist = 5;
    }

    @Override
    public void onFulfilled() {
        LivingEntity owner = this.dog.m_269323_();
        if (owner != null) {
            owner.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.conducting_bone.fulfilled.tp_bed", (Object[])new Object[]{this.dog.m_7755_().getString(), this.dog.getGenderPossessiveAdj()}));
        }
    }

    @Override
    public void onRejected() {
        LivingEntity owner = this.dog.m_269323_();
        if (owner != null) {
            owner.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{Component.m_237113_((String)this.rejectedMsg).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED))}));
        }
    }

    @Override
    public void cleanUp() {
        if (this.bedChunkForced) {
            this.setBedChunk(false);
        }
    }

    private void setBedChunk(boolean loaded) {
        if (this.bedChunkForced == loaded) {
            return;
        }
        ChunkPos chunkpos = new ChunkPos(this.bedPos);
        ForgeChunkManager.forceChunk((ServerLevel)this.level, (String)"doggytalents", (UUID)this.dog.m_20148_(), (int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (boolean)loaded, (boolean)true);
        this.bedChunkForced = loaded;
    }
}

