/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogSwimMoveControl;
import doggytalents.common.entity.ai.nav.DogWaterBoundNavigation;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SwimmerDogTalent
extends TalentInstance {
    private DogSwimMoveControl moveControl;
    private DogWaterBoundNavigation navigator;
    private static final UUID SWIM_BOOST_ID = UUID.fromString("50671e42-1ded-4f97-9e2b-78bbeb1e8772");
    private boolean swimming;
    private float oldWaterCost;
    private float oldWaterBorderCost;

    public SwimmerDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        this.moveControl = new DogSwimMoveControl(dog);
        this.navigator = new DogWaterBoundNavigation(dog, dog.m_9236_());
        this.swimming = false;
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        LivingEntity control;
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.level() >= 5 && dog.m_20160_() && (control = dog.m_6688_()) != null && control.m_20069_()) {
            control.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 80, 1, true, false));
        }
        if (this.swimming) {
            this.updateSwimming(dog);
        } else {
            this.updateNotSwimming(dog);
        }
    }

    @Override
    public void remove(AbstractDog abstractDog) {
        if (this.swimming && abstractDog instanceof Dog) {
            Dog dog = (Dog)abstractDog;
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateSwimming(Dog dog) {
        if (!dog.m_20069_() && dog.m_20096_() || dog.isLowAirSupply()) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(Dog dog) {
        if (dog.m_20069_() && this.readyToBeginSwimming(dog) && !dog.isDogSwimming()) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean readyToBeginSwimming(Dog dog) {
        return dog.m_20146_() == dog.m_6062_();
    }

    private void applySwimAttributes(Dog dog) {
        dog.setAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, "Swim Boost", (double)(2 * dog.getDogLevel((Supplier)DoggyTalents.SWIMMER_DOG)), AttributeModifier.Operation.ADDITION));
    }

    private void removeSwimAttributes(Dog dog) {
        dog.removeAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID);
    }

    private void startSwimming(Dog dog) {
        dog.m_6862_(false);
        dog.setNavigation((PathNavigation)this.navigator);
        dog.setMoveControl(this.moveControl);
        if (dog.m_21825_()) {
            dog.m_21837_(false);
        }
        this.applySwimAttributes(dog);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(Dog dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.setDogSwimming(false);
    }

    @Override
    public InteractionResult canBeRiddenInWater(AbstractDog dogIn) {
        return this.level() >= 2 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Integer> decreaseAirSupply(AbstractDog dogIn, int air) {
        if (this.level() > 0 && dogIn.m_217043_().m_188503_(this.level() + 1) > 0) {
            return InteractionResultHolder.m_19090_((Object)air);
        }
        return InteractionResultHolder.m_19098_((Object)air);
    }

    @Override
    public InteractionResultHolder<Integer> determineNextAir(AbstractDog dogIn, int currentAir) {
        if (this.level() > 0) {
            return InteractionResultHolder.m_19098_((Object)(currentAir + this.level()));
        }
        return InteractionResultHolder.m_19098_((Object)currentAir);
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanSwimUnderwater();
        if (this.level() >= 5) {
            props.setCanBreatheUnderwater();
        }
    }

    @Override
    public InteractionResult canResistPushFromFluidType(FluidType type) {
        if (type != ForgeMod.WATER_TYPE.get()) {
            return InteractionResult.PASS;
        }
        if (this.level() >= 2) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<BlockPathTypes> inferType(AbstractDog dog, BlockPathTypes type) {
        if (type == BlockPathTypes.WATER) {
            return InteractionResultHolder.m_19090_((Object)BlockPathTypes.WALKABLE);
        }
        return super.inferType(dog, type);
    }
}

