/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.feature.DataKey;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RoaringGaleTalent
extends TalentInstance {
    public static DataKey<Integer> COOLDOWN = DataKey.make();

    public RoaringGaleTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    public static int getAffectDuration(int level) {
        if (level >= 5) {
            return 70;
        }
        if (level <= 0) {
            return 0;
        }
        switch (level) {
            case 1: {
                return 20;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 36;
            }
            case 4: {
                return 48;
            }
        }
        return 20;
    }

    public static int getKnockback(int level) {
        return level;
    }

    public static int getDamage(int level) {
        return level > 4 ? level * 2 : level;
    }

    public static void roar(List<Dog> dogsList, Level world, Player player) {
        if (world.f_46443_) {
            return;
        }
        List roarDogs = dogsList.stream().filter(dog -> dog.getDogLevel((Supplier)DoggyTalents.ROARING_GALE) > 0).collect(Collectors.toList());
        if (roarDogs.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"talent.doggytalents.roaring_gale.level"), true);
            return;
        }
        if ((roarDogs = roarDogs.stream().filter(RoaringGaleTalent::isNotOnRoarCooldown).collect(Collectors.toList())).isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"talent.doggytalents.roaring_gale.cooldown"), true);
            return;
        }
        boolean anyHits = false;
        for (Dog dog2 : roarDogs) {
            int level = dog2.getDogLevel((Supplier)DoggyTalents.ROARING_GALE);
            int roarCooldown = dog2.f_19797_;
            int damage = RoaringGaleTalent.getDamage(level);
            int effectDuration = RoaringGaleTalent.getAffectDuration(level);
            int knockback = RoaringGaleTalent.getKnockback(level);
            boolean hit = false;
            List targets = dog2.m_9236_().m_45976_(LivingEntity.class, dog2.m_20191_().m_82377_((double)(level * 4), 4.0, (double)(level * 4)));
            for (LivingEntity mob : targets) {
                if (!(mob instanceof Enemy)) continue;
                hit = true;
                mob.m_6469_(mob.m_269291_().m_269264_(), (float)damage);
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectDuration, 127, false, false));
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, effectDuration, 1, false, false));
                mob.m_5997_((double)(Mth.m_14031_((float)(mob.m_146908_() * ((float)Math.PI / 180))) * (float)knockback * 0.5f), 0.1, (double)(-Mth.m_14089_((float)(mob.m_146908_() * ((float)Math.PI / 180))) * (float)knockback * 0.5f));
            }
            if (hit) {
                dog2.m_5496_(SoundEvents.f_12619_, 0.7f, 1.0f);
                roarCooldown += level >= 5 ? 60 : 100;
                anyHits = true;
            } else {
                dog2.m_5496_(SoundEvents.f_12617_, 1.0f, 1.2f);
                roarCooldown += level >= 5 ? 30 : 50;
            }
            dog2.setData(COOLDOWN, roarCooldown);
        }
        if (!anyHits) {
            player.m_5661_((Component)Component.m_237115_((String)"talent.doggytalents.roaring_gale.miss"), true);
        }
    }

    private static boolean isNotOnRoarCooldown(Dog dog) {
        int cooldownDeadline = dog.getDataOrDefault(COOLDOWN, dog.f_19797_);
        return cooldownDeadline <= dog.f_19797_;
    }
}

