/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import com.mojang.datafixers.util.Pair;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.item.DogEddibleItem;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.network.packet.data.PackPuppyData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.InventoryUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PackPuppyTalent
extends TalentInstance {
    public static final int MAX_DOG_INV_VIEW = 8;
    private boolean renderChest = true;
    private boolean pickupItems = true;
    private boolean offerFood = true;
    private boolean collectKillLoot = true;
    private PackPuppyItemHandler packPuppyHandler;
    private MeatFoodHandler meatFoodHandler = new MeatFoodHandler();
    public static Predicate<ItemEntity> SHOULD_PICKUP_ENTITY_ITEM = entity -> entity.m_6084_() && !entity.m_32063_() && !entity.m_32055_().m_204117_(DoggyTags.PACK_PUPPY_BLACKLIST);
    private final double COLLECT_RADIUS = 2.0;
    private int tickTillUpdateCollect = 10;
    private final int TRIGGER_RADIUS = 12;
    private int tickTillUpdateFood = 30;
    private static int NOTIFY_RADIUS = 20;

    public PackPuppyTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
        PackPuppyItemHandler handler;
        this.packPuppyHandler = handler = new PackPuppyItemHandler();
    }

    public PackPuppyItemHandler inventory() {
        return this.packPuppyHandler;
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        this.tickDogCollectItems(dogIn);
        this.tickOfferFoodToTeammate(dogIn);
    }

    public boolean canCollectItems() {
        return this.level() >= 3;
    }

    public boolean canOfferFood() {
        return this.level() >= 4;
    }

    private void tickDogCollectItems(AbstractDog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (!this.canCollectItems() || !this.pickupItems) {
            return;
        }
        if (--this.tickTillUpdateCollect > 0) {
            return;
        }
        this.tickTillUpdateCollect = 10;
        List itemList = dog.m_9236_().m_6443_(ItemEntity.class, dog.m_20191_().m_82377_(2.0, 1.0, 2.0), SHOULD_PICKUP_ENTITY_ITEM);
        if (itemList.isEmpty()) {
            return;
        }
        for (ItemEntity entity : itemList) {
            ItemStack remaining = InventoryUtil.addItem((IItemHandler)this.packPuppyHandler, entity.m_32055_());
            if (!remaining.m_41619_()) {
                entity.m_32045_(remaining);
                continue;
            }
            entity.m_146870_();
            dog.m_5496_(SoundEvents.f_12019_, 0.25f, ((dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    private void tickOfferFoodToTeammate(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!this.canOfferFood() || !this.offerFood) {
            return;
        }
        if (--this.tickTillUpdateFood > 0) {
            return;
        }
        this.tickTillUpdateFood = 60;
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!this.hasFood(dog, dog)) {
            return;
        }
        List<Dog> hungry_dogs = this.getNearbyHungryDogs(dog);
        if (hungry_dogs.isEmpty()) {
            return;
        }
        for (Dog hungry_dog : hungry_dogs) {
            this.checkAndFeedDog(dog, hungry_dog);
        }
    }

    private void checkAndFeedDog(Dog dog, Dog target) {
        if (target == dog) {
            this.tryFeed(dog, dog, false);
            return;
        }
        if (target.isBusy()) {
            return;
        }
        if (target.m_21825_()) {
            return;
        }
        if (target.m_21827_()) {
            return;
        }
        if (!this.hasFood(dog, target)) {
            return;
        }
        target.triggerAction(new DogEatFromChestDogAction(target, dog));
    }

    private boolean tryFeed(Dog dog, Dog feeder, boolean findHealingFood) {
        int foodSlot = this.findFoodInInv(feeder, dog, findHealingFood);
        if (foodSlot < 0) {
            return false;
        }
        ItemStack feedStack = this.inventory().getStackInSlot(foodSlot).m_41777_();
        Item feedItem = feedStack.m_41720_();
        if (feedItem instanceof IDogEddible) {
            IDogEddible eddible = (IDogEddible)feedItem;
            eddible.consume(dog, feedStack, (Entity)feeder);
        } else {
            this.meatFoodHandler.consume(dog, feedStack, (Entity)feeder);
        }
        this.inventory().setStackInSlot(foodSlot, feedStack);
        return true;
    }

    private List<Dog> getNearbyHungryDogs(Dog dog) {
        List dogs = dog.m_9236_().m_6443_(Dog.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), filter_dog -> this.isEligibleDog(dog, (Dog)filter_dog));
        return dogs;
    }

    private boolean isEligibleDog(Dog offerer, Dog target) {
        if (!this.isHungryDog(target)) {
            return false;
        }
        UUID ownerUUID = offerer.m_21805_();
        if (ownerUUID == null) {
            return false;
        }
        return offerer.willObeyOthers() || !ObjectUtils.notEqual((Object)ownerUUID, (Object)target.m_21805_());
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    @Override
    public void set(AbstractDog dog, int preLevel) {
        if (preLevel > 0 && this.level == 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (dogIn.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        for (int i = 0; i < this.packPuppyHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)dogIn.m_9236_(), (double)dogIn.m_20185_(), (double)dogIn.m_20186_(), (double)dogIn.m_20189_(), (ItemStack)this.packPuppyHandler.getStackInSlot(i));
            this.packPuppyHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128391_(this.packPuppyHandler.serializeNBT());
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag compound) {
        this.renderChest = compound.m_128471_("PackPuppyTalent_renderChest");
        this.pickupItems = compound.m_128471_("PackPuppyTalent_pickupNearby");
        this.offerFood = compound.m_128471_("PackPuppyTalent_offerFood");
        this.collectKillLoot = compound.m_128471_("PackPuppyTalent_collectKillLoot");
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public boolean hasRenderer() {
        return (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_CHEST);
    }

    public static boolean hasInventory(AbstractDog dogIn) {
        return dogIn.isDoingFine() && dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY).isPresent();
    }

    public boolean hasFood(Dog finder, Dog forWho) {
        return this.findFoodInInv(finder, forWho, false) >= 0;
    }

    public int findFoodInInv(Dog finder, Dog target, boolean findHealingFood) {
        int eddibleFoodId = this.findBestDogEddibleFood(finder, target, findHealingFood);
        if (eddibleFoodId >= 0) {
            return eddibleFoodId;
        }
        int meatFoodId = this.findMeatFood(finder, target);
        if (meatFoodId >= 0) {
            return meatFoodId;
        }
        return -1;
    }

    private int findBestDogEddibleFood(Dog finder, Dog target, boolean findHealingFood) {
        PackPuppyItemHandler inventory = this.inventory();
        if (inventory == null) {
            return -1;
        }
        float minNutrition = -1.0f;
        int selectedStack = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            DogEddibleItem eddible;
            ItemStack stack = inventory.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof DogEddibleItem) || !(eddible = (DogEddibleItem)item).canConsume(target, stack, (Entity)finder)) continue;
            if (findHealingFood && this.checkRegenEffects(target, stack, eddible)) {
                return i;
            }
            float addedNutrition = eddible.getAddedHungerWhenDogConsume(stack, target);
            if (minNutrition < 0.0f) {
                minNutrition = addedNutrition;
                selectedStack = i;
                continue;
            }
            if (!(minNutrition > addedNutrition)) continue;
            minNutrition = addedNutrition;
            selectedStack = i;
        }
        return selectedStack;
    }

    private int findMeatFood(Dog finder, Dog target) {
        PackPuppyItemHandler inventory = this.inventory();
        if (inventory == null) {
            return -1;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!this.meatFoodHandler.canConsume(target, stack, (Entity)finder)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkRegenEffects(AbstractDog target, ItemStack stack, DogEddibleItem item) {
        List<Pair<MobEffectInstance, Float>> effects = item.getAdditionalEffectsWhenDogConsume(stack, target);
        for (Pair<MobEffectInstance, Float> pair : effects) {
            MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
            if (effect.m_19544_() != MobEffects.f_19605_) continue;
            return true;
        }
        return false;
    }

    public static PackPuppyTalent getInstanceFromDog(AbstractDog dog) {
        return dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class)).orElse(null);
    }

    @Override
    public void onWrite(AbstractDog dogIn, CompoundTag compound) {
        compound.m_128379_("PackPuppyTalent_renderChest", this.renderChest);
        compound.m_128379_("PackPuppyTalent_pickupNearby", this.pickupItems);
        compound.m_128379_("PackPuppyTalent_offerFood", this.offerFood);
        compound.m_128379_("PackPuppyTalent_collectKillLoot", this.collectKillLoot);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        super.writeToBuf(buf);
        buf.writeBoolean(this.renderChest);
        buf.writeBoolean(this.pickupItems);
        buf.writeBoolean(this.offerFood);
        buf.writeBoolean(this.collectKillLoot);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        super.readFromBuf(buf);
        this.renderChest = buf.readBoolean();
        this.pickupItems = buf.readBoolean();
        this.offerFood = buf.readBoolean();
        this.collectKillLoot = buf.readBoolean();
    }

    @Override
    public void updateOptionsFromServer(TalentInstance fromServer) {
        if (!(fromServer instanceof PackPuppyTalent)) {
            return;
        }
        PackPuppyTalent chest = (PackPuppyTalent)fromServer;
        this.setRenderChest(chest.renderChest);
        this.setPickupItems(chest.pickupItems);
        this.setOfferFood(chest.offerFood);
        this.setCollectKillLoot(chest.collectKillLoot);
    }

    public void updateFromPacket(PackPuppyData data) {
        switch (data.type) {
            default: {
                this.renderChest = data.val;
                break;
            }
            case PICKUP_NEARBY: {
                this.pickupItems = data.val;
                break;
            }
            case OFFER_FOOD: {
                this.offerFood = data.val;
                break;
            }
            case COLLECT_KILL_LOOT: {
                this.collectKillLoot = data.val;
            }
        }
    }

    @Override
    public TalentInstance copy() {
        TalentInstance ret = super.copy();
        if (!(ret instanceof PackPuppyTalent)) {
            return ret;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)ret;
        packPup.setRenderChest(this.renderChest);
        packPup.setPickupItems(this.pickupItems);
        packPup.setOfferFood(this.offerFood);
        packPup.setCollectKillLoot(this.collectKillLoot);
        return packPup;
    }

    public boolean renderChest() {
        return this.renderChest;
    }

    public void setRenderChest(boolean render) {
        this.renderChest = render;
    }

    public boolean pickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean val) {
        this.pickupItems = val;
    }

    public boolean offerFood() {
        return this.offerFood;
    }

    public void setOfferFood(boolean val) {
        this.offerFood = val;
    }

    public boolean collectKillLoot() {
        return this.collectKillLoot;
    }

    public void setCollectKillLoot(boolean val) {
        this.collectKillLoot = val;
    }

    public static void mayNotifyNearbyPackPuppy(LivingDropsEvent event) {
        boolean eligibleKiller;
        DamageSource source = event.getSource();
        LivingEntity killed = event.getEntity();
        Entity killer = source.m_7639_();
        if (killer == null) {
            return;
        }
        if (killer.m_9236_().f_46443_) {
            return;
        }
        Collection drops = event.getDrops();
        if (drops.isEmpty()) {
            return;
        }
        if (!(killer instanceof LivingEntity)) {
            return;
        }
        LivingEntity killerLiving = (LivingEntity)killer;
        boolean bl = eligibleKiller = killerLiving instanceof Player || killerLiving instanceof Dog;
        if (!eligibleKiller) {
            return;
        }
        Optional<Dog> dogOptional = PackPuppyTalent.findNearestChestDogToNotify(killerLiving);
        if (!dogOptional.isPresent()) {
            return;
        }
        Dog dog = dogOptional.get();
        dog.triggerAction(new DogCollectLootAction(dog, killed.m_20183_()));
    }

    private static Optional<Dog> findNearestChestDogToNotify(LivingEntity killer) {
        List dogs = killer.m_9236_().m_6443_(Dog.class, killer.m_20191_().m_82377_((double)NOTIFY_RADIUS, 3.0, (double)NOTIFY_RADIUS), filter_dog -> PackPuppyTalent.isValidItemCollector(filter_dog, killer));
        if (dogs.isEmpty()) {
            return Optional.empty();
        }
        Dog selected_dog = (Dog)dogs.get(0);
        double min_dist = selected_dog.m_20280_((Entity)killer);
        for (Dog dog : dogs) {
            double dist = dog.m_20280_((Entity)killer);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            selected_dog = dog;
        }
        return Optional.ofNullable(selected_dog);
    }

    private static boolean isValidItemCollector(Dog dog, LivingEntity killer) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        if (killer == dog) {
            return false;
        }
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return false;
        }
        UUID killerOwnerUUID = null;
        if (killer instanceof Player) {
            Player player = (Player)killer;
            killerOwnerUUID = player.m_20148_();
        } else if (killer instanceof Dog) {
            Dog killerDog = (Dog)killer;
            killerOwnerUUID = dog.m_21805_();
        }
        if (killerOwnerUUID == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID, (Object)killerOwnerUUID)) {
            return false;
        }
        Optional instOptional = dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY);
        if (!instOptional.isPresent()) {
            return false;
        }
        TalentInstance inst = (TalentInstance)instOptional.get();
        if (!(inst instanceof PackPuppyTalent)) {
            return false;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)inst;
        if (!packPup.canCollectItems()) {
            return false;
        }
        if (!packPup.pickupItems()) {
            return false;
        }
        if (!packPup.collectKillLoot()) {
            return false;
        }
        PackPuppyItemHandler inv = packPup.inventory();
        if (inv == null) {
            return false;
        }
        boolean hasFreeSlot = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            hasFreeSlot = true;
            break;
        }
        return hasFreeSlot;
    }

    public static class DogEatFromChestDogAction
    extends TriggerableAction {
        private Dog target;
        private int tickTillPathRecalc;
        private final int stopDist = 2;
        private boolean enoughHealingFood = false;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromChestDogAction(Dog dog, Dog target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
        }

        @Override
        public void tick() {
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (this.dog.m_20280_((Entity)this.target) > 4.0) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.m_21573_().m_26573_();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.m_21023_(MobEffects.f_19605_);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !inst.tryFeed(this.dog, this.target, true);
            } else {
                this.failedEating = !inst.tryFeed(this.dog, this.target, false);
            }
            this.feedCooldown = this.dog.m_217043_().m_188503_(11);
        }

        private boolean stillValidTarget() {
            if (!this.target.m_6084_()) {
                return false;
            }
            if (this.dog.m_20280_((Entity)this.target) > 256.0) {
                return false;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return false;
            }
            return inst.hasFood(this.target, this.dog);
        }
    }

    public static class DogCollectLootAction
    extends TriggerableAction {
        private BlockPos target;

        public DogCollectLootAction(Dog dog, @NonNull BlockPos target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            if (this.dog.m_20238_(Vec3.m_82539_((Vec3i)this.target)) > 256.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.dog.m_21573_().m_26573_();
            DogUtil.moveToIfReachOrElse(this.dog, this.target, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
                this.target = null;
            });
        }

        @Override
        public void tick() {
            if (this.target == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.m_21573_().m_26571_()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }

        @Override
        public void onStop() {
        }
    }
}

