/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;

public class ChemiCanineTalent
extends TalentInstance {
    private final ArrayList<MobEffectInstance> storedEffects = new ArrayList();
    private final int SEARCH_RADIUS = 12;
    private int absorbEffectCooldown;
    private int tickTillSearch;
    private int tickTillEffectDecay = 0;

    public ChemiCanineTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.tickTillEffectDecay > 0) {
            --this.tickTillEffectDecay;
            if (this.tickTillEffectDecay <= 0 && !this.storedEffects.isEmpty()) {
                this.storedEffects.remove(0);
            }
        }
        if (this.absorbEffectCooldown > 0) {
            --this.absorbEffectCooldown;
            return;
        }
        if (dog.readyForNonTrivialAction() && !dog.m_21827_() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            LivingEntity target = this.findTargetToAbsorb(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerAbsorbAction(dog, target);
            }
        }
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        if (!compound.m_128425_("DTN_ChemiCanine", 10)) {
            return;
        }
        CompoundTag tg0 = compound.m_128469_("DTN_ChemiCanine");
        this.tickTillEffectDecay = tg0.m_128451_("tickTillEffectDecay");
        if (!tg0.m_128425_("effects", 9)) {
            return;
        }
        ListTag effectTags = tg0.m_128437_("effects", 10);
        for (int i = 0; i < effectTags.size(); ++i) {
            try {
                CompoundTag effectTag = effectTags.m_128728_(i);
                MobEffectInstance effectInst = MobEffectInstance.m_19560_((CompoundTag)effectTag);
                this.storedEffects.add(effectInst);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        CompoundTag tg0 = new CompoundTag();
        tg0.m_128405_("tickTillEffectDecay", this.tickTillEffectDecay);
        ListTag effectTags = new ListTag();
        for (MobEffectInstance effect : this.storedEffects) {
            CompoundTag effectTag = new CompoundTag();
            effect.m_19555_(effectTag);
            effectTags.add((Object)effectTag);
        }
        tg0.m_128365_("effects", (Tag)effectTags);
        compound.m_128365_("DTN_ChemiCanine", (Tag)tg0);
    }

    private void triggerAbsorbAction(Dog dog, @Nonnull LivingEntity target) {
        dog.triggerAction(new AbsorbAction(dog, this, target));
    }

    private LivingEntity findTargetToAbsorb(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<LivingEntity> absorbTargets = new ArrayList<LivingEntity>();
        Predicate<LivingEntity> harmfulEffectAndWitness = e -> this.isTargetHaveNegativeEffect(dog, (LivingEntity)e) && dog.m_142582_((Entity)e);
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return null;
        }
        if (harmfulEffectAndWitness.test(owner)) {
            absorbTargets.add(owner);
        }
        if (!(dogs = dog.m_9236_().m_6443_(AbstractDog.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), d -> d.m_269323_() == owner && harmfulEffectAndWitness.test((LivingEntity)d))).isEmpty()) {
            absorbTargets.addAll(dogs);
        }
        if (!(wolves = dog.m_9236_().m_6443_(Wolf.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), w -> w.m_269323_() == owner && harmfulEffectAndWitness.test((LivingEntity)w))).isEmpty()) {
            absorbTargets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.m_9236_().m_6443_(Player.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), p -> p.m_7307_((Entity)owner) && harmfulEffectAndWitness.test((LivingEntity)p))).isEmpty()) {
            absorbTargets.addAll(teamPlayers);
        }
        return this.selectAbsorbTarget(dog, absorbTargets);
    }

    private boolean isTargetHaveNegativeEffect(AbstractDog dog, LivingEntity e) {
        for (MobEffectInstance effectInst : e.m_21220_()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            return true;
        }
        return false;
    }

    private boolean isHarmfulEffect(MobEffectInstance effectInst) {
        return effectInst.m_19544_().m_19483_() == MobEffectCategory.HARMFUL;
    }

    private LivingEntity selectAbsorbTarget(AbstractDog dog, ArrayList<LivingEntity> absorbTargets) {
        if (absorbTargets.isEmpty()) {
            return null;
        }
        LivingEntity target = absorbTargets.get(0);
        double mindistanceSqr = target.m_20280_((Entity)dog);
        LivingEntity owner = dog.m_269323_();
        for (LivingEntity i : absorbTargets) {
            if (owner == i) {
                return i;
            }
            double d = i.m_20280_((Entity)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int absorbCost(AbstractDog dog, LivingEntity target) {
        int cost = this.level() >= 5 ? 10 : 20;
        return cost;
    }

    public int getMaxAbsorbSize() {
        return this.level() * 2;
    }

    private boolean canAffordToAbsorbTarget(AbstractDog dog, LivingEntity e) {
        return dog.getDogHunger() - 10.0f >= (float)this.absorbCost(dog, e) && this.storedEffects.size() < this.getMaxAbsorbSize();
    }

    private boolean stillValidTarget(Dog dog, LivingEntity target) {
        Dog d;
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.isTargetHaveNegativeEffect(dog, target)) {
            return false;
        }
        if (!this.canAffordToAbsorbTarget(dog, target)) {
            return false;
        }
        if (dog.m_20280_((Entity)target) > 400.0) {
            return false;
        }
        return !(target instanceof Dog) || !(d = (Dog)target).isDefeated();
    }

    private boolean canAbsorbTarget(AbstractDog dog, LivingEntity e) {
        return dog.m_20280_((Entity)e) <= 5.0 && dog.m_142582_((Entity)e);
    }

    private void absorb(AbstractDog dog, LivingEntity e) {
        if (this.absorbEffectCooldown > 0) {
            return;
        }
        MobEffect removeEffect = null;
        for (MobEffectInstance effectInst : e.m_21220_()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            removeEffect = effectInst.m_19544_();
            break;
        }
        if (removeEffect == null) {
            return;
        }
        MobEffectInstance effectInst = e.m_21124_(removeEffect);
        if (effectInst == null) {
            return;
        }
        if (this.storedEffects.size() >= this.getMaxAbsorbSize()) {
            return;
        }
        if (!e.m_21195_(removeEffect)) {
            return;
        }
        this.storedEffects.add(effectInst);
        dog.setDogHunger(dog.getDogHunger() - (float)this.absorbCost(dog, e));
        if (dog.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)dog.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123771_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 30, (double)e.m_20205_(), (double)0.8f, (double)e.m_20205_(), 0.1);
        }
        this.absorbEffectCooldown = dog.m_217043_().m_188503_(3) * 20;
        this.tickTillEffectDecay = 24000;
    }

    @Override
    public InteractionResult isPotionApplicable(AbstractDog dogIn, MobEffectInstance effectIn) {
        if (this.level() >= 5 && effectIn.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
        LivingEntity e;
        if (!target.m_6084_()) {
            return;
        }
        if (this.storedEffects.isEmpty()) {
            return;
        }
        MobEffectInstance effectAdding = this.storedEffects.get(0);
        if (target instanceof LivingEntity && !(e = (LivingEntity)target).m_21023_(effectAdding.m_19544_())) {
            e.m_7292_(effectAdding);
            this.storedEffects.remove(effectAdding);
        }
    }

    public static class AbsorbAction
    extends TriggerableAction {
        private ChemiCanineTalent talentInst;
        @Nonnull
        private LivingEntity target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public AbsorbAction(Dog dog, ChemiCanineTalent talentInst, @Nonnull LivingEntity target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public void tick() {
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.m_20280_((Entity)this.target) > 4.0) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else if (this.talentInst.canAbsorbTarget(this.dog, this.target)) {
                this.talentInst.absorb(this.dog, this.target);
            }
        }

        @Override
        public void onStop() {
        }
    }
}

