/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.GatePasserData;
import doggytalents.common.talent.GatePasserTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class GatePasserPacket
extends DogPacket<GatePasserData> {
    @Override
    public void encode(GatePasserData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.allowPassingGate);
    }

    @Override
    public GatePasserData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean val = buf.readBoolean();
        return new GatePasserData(entityId, val);
    }

    @Override
    public void handleDog(Dog dogIn, GatePasserData data, Supplier<NetworkEvent.Context> ctx) {
        Optional talentInstOptional = dogIn.getTalent((Supplier)DoggyTalents.GATE_PASSER);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof GatePasserTalent)) {
            return;
        }
        GatePasserTalent gate = (GatePasserTalent)talentInst;
        gate.updateFromPacket(data);
        dogIn.dogSyncedDataManager.markTalentNeedRefresh(gate);
    }
}

