/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DoggyBeamEntity;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogHowlAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WhistleItem
extends Item
implements IDogItem {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player player, InteractionHand hand) {
        WhistleMode mode;
        ItemStack stack = player.m_21120_(hand);
        int id_mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            id_mode = stack.m_41783_().m_128445_("mode");
        }
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        return (mode = WhistleMode.VALUES[id_mode]) == WhistleMode.MOB_RETRIEVER || mode == WhistleMode.RIDE_WITH_ME || mode == WhistleMode.HOWL ? InteractionResult.FAIL : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (world.f_46443_) {
                WhistleScreen.open();
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        byte id_mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            id_mode = stack.m_41783_().m_128445_("mode");
        }
        List dogsList = world.m_6443_(Dog.class, player.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, dogsList, world, player, hand, false);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void useMode(WhistleMode mode, List<Dog> dogsList, Level world, Player player, InteractionHand hand, boolean isKeyBind) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound()) {
            case NONE: {
                break;
            }
            case LONG: {
                world.m_5594_(null, player.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
                break;
            }
            case SHORT: {
                world.m_5594_(null, player.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode) {
            case STAND: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    dog.m_21839_(false);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    if (dog.getMode() == EnumMode.WANDERING) {
                        dog.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.come"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL: {
                if (world.f_46443_) {
                    return;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (filter_dog.m_21827_()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.m_20280_((Entity)filter_dog.m_269323_()) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((Entity)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (LivingEntity)player, 3);
                player.m_213846_((Component)Component.m_237115_((String)"dogcommand.heel"));
                return;
            }
            case STAY: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    dog.m_21839_(true);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    if (dog.getMode() == EnumMode.WANDERING) {
                        dog.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.stay"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case OKAY: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    dog.m_21839_(dog.m_21233_() / 2.0f >= dog.m_21223_());
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.ok"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case SHELPERD: {
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case TACTICAL: {
                if (world.f_46443_) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (LivingEntity)player);
                doggyBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 1.0f);
                world.m_7967_((Entity)doggyBeam);
                return;
            }
            case ROAR: {
                RoaringGaleTalent.roar(dogsList, world, player);
                return;
            }
            case HEEL_BY_NAME: {
                if (world.f_46443_) {
                    HeelByNameScreen.open(isKeyBind ? 200L : 0L);
                }
                return;
            }
            case TO_BED: {
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.m_9236_().f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    BlockPos bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (BlockPos)dog.getBedPos((ResourceKey<Level>)player.m_9236_().m_46472_()).orElse(null)) == null || dog.m_20183_().equals((Object)bedPos) && dog.m_21825_() || !(dog.m_20238_(Vec3.m_82539_((Vec3i)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                return;
            }
            case GO_BEHIND: {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    LivingEntity owner;
                    if (!dog.getMode().shouldFollowOwner() || dog.m_21827_() || (owner = dog.m_269323_()) == null || dog.m_20280_((Entity)owner) > 400.0) continue;
                    dog.m_6710_(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL_BY_GROUP: {
                if (world.f_46443_) {
                    HeelByGroupScreen.open();
                }
                return;
            }
            case MOB_RETRIEVER: {
                AABB search_area;
                Vec3 view_vec;
                Vec3 max_reach_vec;
                Vec3 max_pos;
                if (world.f_46443_) {
                    return;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                Optional<Dog> retrieverOptional = MobRetrieverTalent.chooseNearestDog(player, world);
                if (retrieverOptional.isEmpty()) {
                    return;
                }
                Dog retriever = retrieverOptional.get();
                Optional<TalentInstance> talentOptional = retriever.getTalent((Talent)DoggyTalents.MOB_RETRIEVER.get());
                if (talentOptional.isEmpty()) {
                    return;
                }
                MobRetrieverTalent talentInst = (MobRetrieverTalent)talentOptional.get();
                int reach_range = MobRetrieverTalent.getSelectTargetRange();
                Vec3 eye_pos = player.m_146892_();
                EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.m_82549_(max_reach_vec = (view_vec = player.m_20252_(1.0f)).m_82490_((double)reach_range))), (AABB)(search_area = player.m_20191_().m_82369_(max_reach_vec).m_82377_(1.0, 1.0, 1.0)), e -> {
                    if (!(e instanceof LivingEntity)) {
                        return false;
                    }
                    LivingEntity living = (LivingEntity)e;
                    return talentInst.isValidTarget(retriever, living);
                }, (double)(reach_range * reach_range));
                if (hitResult == null) {
                    return;
                }
                Entity entity = hitResult.m_82443_();
                if (entity == null) {
                    return;
                }
                talentInst.setTarget(retriever, (LivingEntity)entity);
                return;
            }
            case HEEL_BY_LOOK: {
                this.heelByLook(world, player);
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case RIDE_WITH_ME: {
                this.rideWithMe(world, player);
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HOWL: {
                this.howl(world, player);
                return;
            }
        }
    }

    private void rideWithMe(Level level, Player player) {
        AABB search_area;
        Vec3 view_vec;
        Vec3 max_reach_vec;
        Vec3 max_pos;
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Vec3 eye_pos = player.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.m_82549_(max_reach_vec = (view_vec = player.m_20252_(1.0f)).m_82490_(30.0))), (AABB)(search_area = player.m_20191_().m_82369_(max_reach_vec).m_82377_(1.0, 1.0, 1.0)), e -> e instanceof Dog, (double)900.0);
        if (hitResult == null) {
            return;
        }
        Entity entity = hitResult.m_82443_();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        if (dog.m_20159_()) {
            dog.m_19877_();
            return;
        }
        Entity vehicle = player.m_20202_();
        if (vehicle == null) {
            return;
        }
        dog.authorizeRiding();
        boolean result = dog.m_20329_(vehicle);
        if (result) {
            player.m_213846_((Component)Component.m_237110_((String)"dogcommand.ride_with_me", (Object[])new Object[]{dog.m_7755_().getString()}));
        }
    }

    private void heelByLook(Level level, Player player) {
        AABB search_area;
        Vec3 view_vec;
        Vec3 max_reach_vec;
        Vec3 max_pos;
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Vec3 eye_pos = player.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.m_82549_(max_reach_vec = (view_vec = player.m_20252_(1.0f)).m_82490_(30.0))), (AABB)(search_area = player.m_20191_().m_82369_(max_reach_vec).m_82377_(1.0, 1.0, 1.0)), e -> {
            Dog dog;
            return e instanceof Dog && (dog = (Dog)e).isDoingFine();
        }, (double)900.0);
        if (hitResult == null) {
            return;
        }
        Entity entity = hitResult.m_82443_();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (LivingEntity)player, 2);
        player.m_213846_((Component)Component.m_237110_((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.m_7755_().getString()}));
        dog.m_21839_(false);
    }

    private void howl(Level level, Player player) {
        AABB search_area;
        Vec3 view_vec;
        Vec3 max_reach_vec;
        Vec3 max_pos;
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Vec3 eye_pos = player.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.m_82549_(max_reach_vec = (view_vec = player.m_20252_(1.0f)).m_82490_(30.0))), (AABB)(search_area = player.m_20191_().m_82369_(max_reach_vec).m_82377_(1.0, 1.0, 1.0)), e -> e instanceof Dog, (double)900.0);
        if (hitResult == null) {
            return;
        }
        Entity entity = hitResult.m_82443_();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        if (!dog.readyForNonTrivialAction()) {
            return;
        }
        dog.triggerAction(new DogHowlAction(dog));
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + player.m_9236_().f_46441_.m_188501_() * 0.1f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.2f);
    }

    public String m_5671_(ItemStack stack) {
        byte mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            mode = stack.m_41783_().m_128445_("mode");
        }
        return this.m_5524_() + "." + mode;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5524_() + ".description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        OKAY(3, WhistleSound.LONG),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE),
        MOB_RETRIEVER(11, WhistleSound.SHORT),
        HEEL_BY_LOOK(12, WhistleSound.SHORT),
        RIDE_WITH_ME(13, WhistleSound.SHORT),
        HOWL(14, WhistleSound.NONE);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

