/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.item.DyableBirthdayHatItem;
import doggytalents.common.util.ColourCache;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BirthdayHatAccessory
extends Accessory
implements IAccessoryHasModel {
    public BirthdayHatAccessory(Supplier<? extends ItemLike> itemIn) {
        super((Supplier<? extends AccessoryType>)DoggyAccessoryTypes.HEAD, itemIn);
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.BIRTHDAY_HAT;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst((Accessory)this, 0, 0);
    }

    @Override
    public AccessoryInstance createInstance(FriendlyByteBuf buf) {
        int bg_color = buf.readInt();
        int fg_color = buf.readInt();
        return new Inst((Accessory)this, bg_color, fg_color);
    }

    @Override
    public void write(AccessoryInstance instance, FriendlyByteBuf buf) {
        if (!(instance instanceof Inst)) {
            buf.writeInt(0);
            buf.writeInt(0);
            return;
        }
        Inst inst = (Inst)instance;
        buf.writeInt(inst.getColorInteger());
        buf.writeInt(inst.getFgColorInteger());
    }

    @Override
    public void write(AccessoryInstance instance, CompoundTag compound) {
        if (!(instance instanceof Inst)) {
            return;
        }
        Inst inst = (Inst)instance;
        compound.m_128405_("color", inst.getColorInteger());
        compound.m_128405_("bdhat_fg_color", inst.getFgColorInteger());
    }

    @Override
    public AccessoryInstance read(CompoundTag compound) {
        int bg_color = compound.m_128451_("color");
        int fg_color = compound.m_128451_("bdhat_fg_color");
        return new Inst((Accessory)this, bg_color, fg_color);
    }

    @Override
    public AccessoryInstance createFromStack(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof DyableBirthdayHatItem) {
            DyableBirthdayHatItem birthday = (DyableBirthdayHatItem)item;
            return new Inst((Accessory)this, birthday.m_41121_(stackIn), birthday.getForegroundColor(stackIn));
        }
        return this.getDefault();
    }

    @Override
    public ItemStack getReturnItem(AccessoryInstance instance) {
        ItemStack returnStack = super.getReturnItem(instance);
        if (!(instance instanceof Inst)) {
            return returnStack;
        }
        Inst inst = (Inst)instance;
        Item item = returnStack.m_41720_();
        if (item instanceof DyableBirthdayHatItem) {
            DyableBirthdayHatItem birthday = (DyableBirthdayHatItem)item;
            birthday.m_41115_(returnStack, inst.getColorInteger());
            birthday.setForegroundColor(returnStack, inst.getFgColorInteger());
        }
        return returnStack;
    }

    public static class Inst
    extends AccessoryInstance
    implements IColoredObject {
        private ColourCache bgColor;
        private ColourCache fgColor;

        public Inst(Accessory typeIn, int bgColor, int fgColor) {
            this(typeIn, ColourCache.make(bgColor), ColourCache.make(fgColor));
        }

        public Inst(Accessory type, ColourCache bgColor, ColourCache fgColor) {
            super(type);
            this.bgColor = bgColor;
            this.fgColor = fgColor;
        }

        @Override
        public float[] getColor() {
            return this.bgColor.getFloatArray();
        }

        public float[] getFgColor() {
            return this.fgColor.getFloatArray();
        }

        public int getColorInteger() {
            return this.bgColor.get();
        }

        public int getFgColorInteger() {
            return this.fgColor.get();
        }

        @Override
        public AccessoryInstance copy() {
            return new Inst(this.getAccessory(), this.bgColor, this.fgColor);
        }
    }
}

