/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.common.lib.Resources;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DoggySpin
extends AbstractWidget {
    private int size;
    private Style style = Style.CHOPIN;
    private Random random = new Random();
    private int indx = 0;
    private long lastRender;

    public DoggySpin(int x, int y, int size) {
        super(x, y, size, size, (Component)Component.m_237119_());
        this.size = size;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        switch (this.style) {
            default: {
                this.drawSpin(graphics, this.m_252754_(), this.m_252907_(), this.size);
                break;
            }
            case BACKFLIP: {
                this.drawSpin2(graphics, this.m_252754_(), this.m_252907_(), this.size);
                break;
            }
            case SIT: {
                this.drawSpin3(graphics, this.m_252754_(), this.m_252907_(), this.size);
                break;
            }
            case AMMY: {
                this.drawAmmy(graphics, this.m_252754_(), this.m_252907_(), this.size);
            }
        }
    }

    private void drawSpin(GuiGraphics graphics, int x, int y, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 6 * size;
        if (System.currentTimeMillis() - this.lastRender > 50L) {
            this.lastRender = System.currentTimeMillis();
            this.indx = (this.indx + 1) % 35;
        }
        int uvX = Mth.m_14143_((float)(this.indx % 6));
        int uvY = Mth.m_14143_((float)(this.indx / 6));
        graphics.m_280398_(Resources.SPIN, x, y, 0, (float)(uvX * size), (float)(uvY * size), size, size, 6 * size, 6 * size);
        RenderSystem.disableBlend();
    }

    private void drawSpin2(GuiGraphics graphics, int x, int y, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 7 * size;
        if (System.currentTimeMillis() - this.lastRender > 50L) {
            this.lastRender = System.currentTimeMillis();
            this.indx = (this.indx + 1) % 30;
        }
        int uvX = Mth.m_14143_((float)(this.indx % 7));
        int uvY = Mth.m_14143_((float)(this.indx / 7));
        graphics.m_280398_(Resources.SPIN2, x, y, 0, (float)(uvX * size), (float)(uvY * size), size, size, 7 * size, 5 * size);
        RenderSystem.disableBlend();
    }

    private void drawSpin3(GuiGraphics graphics, int x, int y, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 9 * size;
        if (System.currentTimeMillis() - this.lastRender > 50L) {
            this.lastRender = System.currentTimeMillis();
            this.indx = (this.indx + 1) % 100;
        }
        int uvX = Mth.m_14143_((float)(this.indx % 9));
        int uvY = Mth.m_14143_((float)(this.indx / 9));
        graphics.m_280398_(Resources.SPIN3, x, y, 0, (float)(uvX * size), (float)(uvY * size), size, size, 9 * size, 12 * size);
        RenderSystem.disableBlend();
    }

    private void drawAmmy(GuiGraphics graphics, int x, int y, int size) {
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_85841_(1.5f, 1.5f, 1.5f);
        x = (int)((float)x / 1.5f);
        y = (int)((float)y / 1.5f);
        x -= 22;
        y -= 22;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 6 * size;
        if (System.currentTimeMillis() - this.lastRender > 50L) {
            this.lastRender = System.currentTimeMillis();
            this.indx = (this.indx + 1) % 40;
        }
        int uvX = Mth.m_14143_((float)(this.indx % 6));
        int uvY = Mth.m_14143_((float)(this.indx / 6));
        graphics.m_280398_(Resources.SPIN4, x, y, 0, (float)(uvX * size), (float)(uvY * size), size, size, 6 * size, 7 * size);
        RenderSystem.disableBlend();
        stack.m_85849_();
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void chooseStyle() {
        int r = this.random.nextInt(8);
        switch (r) {
            default: {
                this.style = Style.CHOPIN;
                break;
            }
            case 0: 
            case 1: {
                this.style = Style.BACKFLIP;
                break;
            }
            case 2: {
                this.style = Style.SIT;
                break;
            }
            case 3: {
                this.style = Style.AMMY;
            }
        }
        this.indx = 0;
        this.lastRender = System.currentTimeMillis();
    }

    private static enum Style {
        CHOPIN,
        BACKFLIP,
        SIT,
        AMMY;

    }
}

