/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView;

import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.DogNewInfoScreen.store.UIActionTypes;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveSkinSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogTextureData;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.PacketDistributor;

public class SkinButtonElement
extends AbstractElement {
    Dog dog;
    Font font;
    List<DogSkin> locList;
    Button showHideInfoButton;
    Button applyButton;
    int activeSkinId;
    boolean showInfo;
    Consumer<GuiEventListener> leftAction;
    Consumer<GuiEventListener> rightAction;

    public SkinButtonElement(AbstractElement parent, Screen screen, Dog dog, List<DogSkin> locList, int active_id, Consumer<GuiEventListener> leftAction, Consumer<GuiEventListener> rightAction) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.activeSkinId = active_id;
        this.locList = locList;
        this.leftAction = leftAction;
        this.rightAction = rightAction;
    }

    @Override
    public AbstractElement init() {
        this.showInfo = this.getStateAndSubscribesTo(ActiveSkinSlice.class, ActiveSkinSlice.class, new ActiveSkinSlice()).showInfo;
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        if (this.locList == null) {
            return this;
        }
        if (this.locList.isEmpty()) {
            return this;
        }
        TextOnlyButton prevSkinButton = new TextOnlyButton(this.getRealX() + 10, this.getRealY() + mY - 9, 18, 18, (Component)Component.m_237113_((String)"<"), b -> this.leftAction.accept((GuiEventListener)b), this.font);
        prevSkinButton.f_93623_ = this.activeSkinId > 0;
        TextOnlyButton nextSkinButton = new TextOnlyButton(this.getRealX() + 75, this.getRealY() + mY - 9, 18, 18, (Component)Component.m_237113_((String)">"), b -> this.rightAction.accept((GuiEventListener)b), this.font);
        nextSkinButton.f_93623_ = this.activeSkinId < this.locList.size() - 1;
        this.showHideInfoButton = this.applyButton = new CustomButton(this.getRealX() + this.getSizeX() - 30 - 30 - 62, this.getRealY() + mY - 10, 58, 20, (Component)Component.m_237113_((String)(!this.showInfo ? "Show Info" : "Hide Info")), b -> Store.get(this.getScreen()).dispatch(ActiveSkinSlice.class, new UIAction(!this.showInfo ? UIActionTypes.Skins.SHOW_INFO : UIActionTypes.Skins.HIDE_INFO, new ActiveSkinSlice())));
        this.applyButton = new CustomButton(this.getRealX() + this.getSizeX() - 30 - 30, this.getRealY() + mY - 10, 40, 20, (Component)Component.m_237113_((String)"Apply"), b -> this.applyAndRequestSkinChange(this.activeSkinId));
        this.applyButton.f_93623_ = this.locList.get(this.activeSkinId) != this.dog.getClientSkin();
        this.addChildren((GuiEventListener)prevSkinButton);
        this.addChildren((GuiEventListener)nextSkinButton);
        this.addChildren((GuiEventListener)this.applyButton);
        this.addChildren((GuiEventListener)this.showHideInfoButton);
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int tX = this.getRealX() + 52;
        int n = this.getRealY() + this.getSizeY() / 2;
        Objects.requireNonNull(this.font);
        int tY = n - 9 / 2;
        String str = this.activeSkinId + 1 + "/" + this.locList.size();
        graphics.m_280488_(this.font, str, tX -= this.font.m_92895_(str) / 2, tY, -1);
    }

    public void applyAndRequestSkinChange(int id) {
        int size = this.locList.size();
        if (id >= size || id < 0) {
            return;
        }
        DogSkin selectedSkin = this.locList.get(id);
        String requestHash = null;
        requestHash = selectedSkin == DogSkin.CLASSICAL || selectedSkin == DogSkin.MISSING ? "" : DogTextureManager.INSTANCE.getHash(this.locList.get(id));
        this.applyButton.f_93623_ = false;
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTextureData(this.dog.m_19879_(), requestHash));
    }
}

