/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Steep
extends RoofBlock {
    protected static final VoxelShape WEST = Block.m_49796_((double)0.0, (double)0.1, (double)0.0, (double)8.0, (double)15.9, (double)16.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)15.9, (double)8.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)8.0, (double)0.1, (double)0.0, (double)16.0, (double)15.9, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.1, (double)8.0, (double)16.0, (double)15.9, (double)16.0);
    protected static final VoxelShape OUTER_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OUTER_EAST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OUTER_SOUTH = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OUTER_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape INNER_WEST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    protected static final VoxelShape INNER_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    protected static final VoxelShape INNER_EAST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape INNER_SOUTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));

    public Steep(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)SHAPE, (Comparable)Steep.getStairsShape((BlockGetter)access, pos, (Direction)state.m_61143_((Property)FACING), (Half)state.m_61143_((Property)HALF))) : super.m_7417_(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.m_8055_(pos.m_121945_(direction));
        if (Steep.isSteep(blockstate) && half == blockstate.m_61143_((Property)HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && Steep.canTakeShape(direction1.m_122424_(), blockstate, reader, pos)) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (Steep.isSteep(blockstate1) && half == blockstate1.m_61143_((Property)HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && Steep.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos.m_121945_(dir));
        return !Steep.isSteep(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockstate.m_61143_((Property)HALF) != state.m_61143_((Property)HALF);
    }

    public static boolean isSteep(BlockState state) {
        return state.m_60734_() instanceof Steep;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        StairsShape shape = (StairsShape)state.m_61143_((Property)SHAPE);
        switch (facing) {
            case WEST: {
                return this.getWestShape(shape);
            }
            case EAST: {
                return this.getEastShape(shape);
            }
            case SOUTH: {
                return this.getSouthShape(shape);
            }
            case NORTH: {
                return this.getNorthShape(shape);
            }
        }
        return null;
    }

    private VoxelShape getWestShape(StairsShape shape) {
        if (shape == StairsShape.OUTER_RIGHT) {
            return OUTER_NORTH;
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return OUTER_WEST;
        }
        if (shape == StairsShape.INNER_LEFT) {
            return INNER_EAST;
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return INNER_WEST;
        }
        return WEST;
    }

    private VoxelShape getEastShape(StairsShape shape) {
        if (shape == StairsShape.OUTER_RIGHT) {
            return OUTER_SOUTH;
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return OUTER_EAST;
        }
        if (shape == StairsShape.INNER_LEFT) {
            return INNER_NORTH;
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return INNER_SOUTH;
        }
        return EAST;
    }

    private VoxelShape getSouthShape(StairsShape shape) {
        if (shape == StairsShape.OUTER_RIGHT) {
            return OUTER_WEST;
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return OUTER_SOUTH;
        }
        if (shape == StairsShape.INNER_LEFT) {
            return INNER_SOUTH;
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return INNER_EAST;
        }
        return SOUTH;
    }

    private VoxelShape getNorthShape(StairsShape shape) {
        if (shape == StairsShape.OUTER_RIGHT) {
            return OUTER_EAST;
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return OUTER_NORTH;
        }
        if (shape == StairsShape.INNER_LEFT) {
            return INNER_WEST;
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return INNER_NORTH;
        }
        return NORTH;
    }
}

