/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.lua.LuaException;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ModemState {
    @Nullable
    private final Runnable onChanged;
    private final AtomicBoolean changed = new AtomicBoolean(true);
    private boolean open = false;
    private final IntSet channels = new IntOpenHashSet();

    public ModemState() {
        this.onChanged = null;
    }

    public ModemState(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    private void setOpen(boolean open) {
        if (this.open == open) {
            return;
        }
        this.open = open;
        if (!this.changed.getAndSet(true) && this.onChanged != null) {
            this.onChanged.run();
        }
    }

    public boolean pollChanged() {
        return this.changed.getAndSet(false);
    }

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen(int channel) {
        IntSet intSet = this.channels;
        synchronized (intSet) {
            return this.channels.contains(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int channel) throws LuaException {
        IntSet intSet = this.channels;
        synchronized (intSet) {
            if (!this.channels.contains(channel)) {
                if (this.channels.size() >= 128) {
                    throw new LuaException("Too many open channels");
                }
                this.channels.add(channel);
                this.setOpen(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int channel) {
        IntSet intSet = this.channels;
        synchronized (intSet) {
            this.channels.remove(channel);
            if (this.channels.isEmpty()) {
                this.setOpen(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        IntSet intSet = this.channels;
        synchronized (intSet) {
            this.channels.clear();
            this.setOpen(false);
        }
    }
}

