/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UploadFileMessage
extends ComputerServerMessage {
    static final int MAX_PACKET_SIZE = 30720;
    private static final int HEADER_SIZE = 17;
    public static final int MAX_FILES = 32;
    public static final int MAX_FILE_NAME = 128;
    @VisibleForTesting
    static final int FLAG_FIRST = 1;
    @VisibleForTesting
    static final int FLAG_LAST = 2;
    private final UUID uuid;
    @VisibleForTesting
    final int flag;
    @Nullable
    @VisibleForTesting
    final List<FileUpload> files;
    @VisibleForTesting
    final List<FileSlice> slices;

    UploadFileMessage(AbstractContainerMenu menu, UUID uuid, int flag, @Nullable List<FileUpload> files, List<FileSlice> slices) {
        super(menu);
        this.uuid = uuid;
        this.flag = flag;
        this.files = files;
        this.slices = slices;
    }

    public UploadFileMessage(FriendlyByteBuf buf) {
        super(buf);
        int i;
        this.uuid = buf.m_130259_();
        byte by = buf.readByte();
        this.flag = by;
        byte flag = by;
        int totalSize = 0;
        if ((flag & 1) != 0) {
            int nFiles = buf.m_130242_();
            if (nFiles > 32) {
                throw new DecoderException("Too many files");
            }
            this.files = new ArrayList<FileUpload>(nFiles);
            ArrayList<FileUpload> files = this.files;
            for (i = 0; i < nFiles; ++i) {
                String name = buf.m_130136_(128);
                int size = buf.m_130242_();
                if (size > Config.uploadMaxSize || (totalSize += size) > Config.uploadMaxSize) {
                    throw new DecoderException("Files are too large");
                }
                byte[] digest = new byte[32];
                buf.readBytes(digest);
                files.add(new FileUpload(name, ByteBuffer.allocateDirect(size), digest));
            }
        } else {
            this.files = null;
        }
        int nSlices = buf.m_130242_();
        this.slices = new ArrayList<FileSlice>(nSlices);
        ArrayList<FileSlice> slices = this.slices;
        for (i = 0; i < nSlices; ++i) {
            short fileId = buf.readUnsignedByte();
            int offset = buf.m_130242_();
            int size = buf.readUnsignedShort();
            if (size > 30720) {
                throw new DecoderException("File is too large");
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buf.readBytes(buffer);
            buffer.flip();
            slices.add(new FileSlice(fileId, offset, buffer));
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130077_(this.uuid);
        buf.writeByte(this.flag);
        if ((this.flag & 1) != 0) {
            List<FileUpload> files = Nullability.assertNonNull(this.files);
            buf.m_130130_(files.size());
            for (FileUpload file : files) {
                buf.m_130072_(file.getName(), 128);
                buf.m_130130_(file.getLength());
                buf.writeBytes(file.getChecksum());
            }
        }
        buf.m_130130_(this.slices.size());
        for (FileSlice slice : this.slices) {
            buf.writeByte(slice.fileId());
            buf.m_130130_(slice.offset());
            ByteBuffer bytes = slice.bytes().duplicate();
            buf.writeShort(bytes.remaining());
            buf.writeBytes(bytes);
        }
    }

    public static void send(AbstractContainerMenu container, List<FileUpload> files, Consumer<UploadFileMessage> send) {
        UUID uuid = UUID.randomUUID();
        int remaining = 30703;
        for (FileUpload file : files) {
            remaining -= 4 + file.getName().length() * 4 + 32;
        }
        boolean first = true;
        ArrayList<FileSlice> slices = new ArrayList<FileSlice>(files.size());
        for (int fileId = 0; fileId < files.size(); ++fileId) {
            FileUpload file = files.get(fileId);
            ByteBuffer contents = file.getBytes();
            int capacity = contents.limit();
            int currentOffset = 0;
            while (currentOffset < capacity) {
                if (remaining <= 0) {
                    send.accept(first ? new UploadFileMessage(container, uuid, 1, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(container, uuid, 0, null, new ArrayList<FileSlice>(slices)));
                    slices.clear();
                    remaining = 30703;
                    first = false;
                }
                int canWrite = Math.min(remaining, capacity - currentOffset);
                contents.position(currentOffset).limit(currentOffset + canWrite);
                slices.add(new FileSlice(fileId, currentOffset, contents.slice()));
                currentOffset += canWrite;
                remaining -= canWrite;
            }
            contents.position(0).limit(capacity);
        }
        send.accept(first ? new UploadFileMessage(container, uuid, 3, files, new ArrayList<FileSlice>(slices)) : new UploadFileMessage(container, uuid, 2, null, new ArrayList<FileSlice>(slices)));
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerPlayer player = context.getSender();
        ServerInputHandler input = container.getInput();
        if ((this.flag & 1) != 0) {
            input.startUpload(this.uuid, Nullability.assertNonNull(this.files));
        }
        input.continueUpload(this.uuid, this.slices);
        if ((this.flag & 2) != 0) {
            input.finishUpload(player, this.uuid);
        }
    }

    @Override
    public MessageType<UploadFileMessage> type() {
        return NetworkMessages.UPLOAD_FILE;
    }
}

