/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class ChatHelpers {
    private static final ChatFormatting HEADER = ChatFormatting.LIGHT_PURPLE;

    private ChatHelpers() {
    }

    public static MutableComponent coloured(@Nullable String text, ChatFormatting colour) {
        return ChatHelpers.text(text).m_130940_(colour);
    }

    public static MutableComponent text(@Nullable String text) {
        return Component.m_237113_((String)(text == null ? "" : text));
    }

    public static MutableComponent list(Component ... children) {
        MutableComponent component = Component.m_237119_();
        for (Component child : children) {
            component.m_7220_(child);
        }
        return component;
    }

    public static MutableComponent position(@Nullable BlockPos pos) {
        if (pos == null) {
            return Component.m_237115_((String)"commands.computercraft.generic.no_position");
        }
        return Component.m_237110_((String)"commands.computercraft.generic.position", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public static MutableComponent bool(boolean value) {
        return value ? Component.m_237115_((String)"commands.computercraft.generic.yes").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"commands.computercraft.generic.no").m_130940_(ChatFormatting.RED);
    }

    public static Component link(MutableComponent component, String command, Component toolTip) {
        return ChatHelpers.link((Component)component, new ClickEvent(ClickEvent.Action.RUN_COMMAND, command), toolTip);
    }

    public static Component link(Component component, ClickEvent click, Component toolTip) {
        Style style = component.m_7383_();
        if (style.m_131135_() == null) {
            style = style.m_131140_(ChatFormatting.YELLOW);
        }
        style = style.m_131142_(click);
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)toolTip));
        return component.m_6881_().m_130948_(style);
    }

    public static MutableComponent header(String text) {
        return ChatHelpers.coloured(text, HEADER);
    }

    public static MutableComponent copy(String text) {
        return Component.m_237113_((String)text).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.computercraft.tooltip.copy"))));
    }
}

