/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.github.mortuusars.chalk.utils.ParticleUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChalkMark {
    public static InteractionResult tryDraw(MarkSymbol symbol, DyeColor color, boolean isGlowing, BlockPos clickedPos, Direction clickedFace, Vec3 clickLocation, Level level) {
        if (!ChalkMark.canBeDrawnAt(clickedPos.m_121945_(clickedFace), clickedPos, clickedFace, level)) {
            return InteractionResult.FAIL;
        }
        boolean isClickedOnAMark = level.m_8055_(clickedPos).m_60734_() instanceof ChalkMarkBlock;
        BlockPos newMarkPosition = isClickedOnAMark ? clickedPos : clickedPos.m_121945_(clickedFace);
        Direction newMarkFacing = isClickedOnAMark ? (Direction)level.m_8055_(newMarkPosition).m_61143_((Property)ChalkMarkBlock.FACING) : clickedFace;
        BlockState markBlockState = (BlockState)((BlockState)((BlockState)((BlockState)Chalk.Blocks.getMarkBlock(color).m_49966_().m_61124_((Property)ChalkMarkBlock.FACING, (Comparable)newMarkFacing)).m_61124_(ChalkMarkBlock.SYMBOL, (Comparable)((Object)symbol))).m_61124_(ChalkMarkBlock.ORIENTATION, (Comparable)((Object)SymbolOrientation.fromClickLocationAll(clickLocation, clickedFace)))).m_61124_((Property)ChalkMarkBlock.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
        if (isClickedOnAMark) {
            BlockState oldMarkBlockState = level.m_8055_(newMarkPosition);
            if (((SymbolOrientation)((Object)markBlockState.m_61143_(ChalkMarkBlock.ORIENTATION))).equals(oldMarkBlockState.m_61143_(ChalkMarkBlock.ORIENTATION)) && newMarkFacing == oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.FACING) && symbol == oldMarkBlockState.m_61143_(ChalkMarkBlock.SYMBOL) && (!isGlowing || ((Boolean)oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.GLOWING)).booleanValue())) {
                return InteractionResult.FAIL;
            }
            level.m_7471_(newMarkPosition, false);
        }
        ChalkMark.drawMark(markBlockState, newMarkPosition, level);
        return InteractionResult.SUCCESS;
    }

    public static boolean canBeDrawnAt(BlockPos pos, BlockPos clickedBlockPos, Direction clickedFace, Level level) {
        BlockState clickedBlockState = level.m_8055_(clickedBlockPos);
        if (clickedBlockState.m_60734_() instanceof ChalkMarkBlock) {
            return true;
        }
        BlockState stateAtMarkPos = level.m_8055_(pos);
        if (stateAtMarkPos.m_60795_() || stateAtMarkPos.m_60734_() instanceof ChalkMarkBlock) {
            return Block.m_49918_((VoxelShape)clickedBlockState.m_60812_((BlockGetter)level, clickedBlockPos), (Direction)clickedFace);
        }
        return false;
    }

    public static boolean canBeDrawnOn(BlockPos pos, Direction face, Level level) {
        BlockState blockStateAtPos = level.m_8055_(pos);
        return ChalkMark.canMarkReplace(level.m_8055_(pos.m_121945_(face))) && Block.m_49918_((VoxelShape)blockStateAtPos.m_60812_((BlockGetter)level, pos), (Direction)face);
    }

    public static boolean canMarkReplace(BlockState state) {
        return state.m_60795_() || state.m_60734_() instanceof ChalkMarkBlock;
    }

    public static boolean drawMark(BlockState markState, BlockPos markPos, Level level) {
        boolean isMarkDrawn = level.m_7731_(markPos, markState, 11);
        if (isMarkDrawn) {
            double pX = (double)markPos.m_123341_() + 0.5;
            double pY = (double)markPos.m_123342_() + 0.5;
            double pZ = (double)markPos.m_123343_() + 0.5;
            level.m_6263_(null, pX, pY, pZ, (SoundEvent)Chalk.SoundEvents.MARK_DRAW.get(), SoundSource.BLOCKS, 0.7f, new Random().nextFloat() * 0.2f + 0.8f);
            if (level.f_46443_) {
                DyeColor color = ((ChalkMarkBlock)markState.m_60734_()).getColor();
                ParticleUtils.spawnColorDustParticles(color, level, markPos, (Direction)markState.m_61143_((Property)ChalkMarkBlock.FACING));
            }
        }
        return isMarkDrawn;
    }
}

