/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.palettes;

import com.simibubi.create.content.decoration.palettes.LayeredBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.LevelTickAccess;

public class ConnectedPillarBlock
extends LayeredBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");

    public ConnectedPillarBlock(BlockBehaviour.Properties p_55926_) {
        super(p_55926_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        return this.updateColumn(pContext.m_43725_(), pContext.m_8083_(), state, true);
    }

    private BlockState updateColumn(Level level, BlockPos pos, BlockState state, boolean present) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
        for (Direction connection : Iterate.directions) {
            if (connection.m_122434_() == axis) continue;
            boolean connect = true;
            block1: for (Direction movement : Iterate.directionsInAxis(axis)) {
                currentPos.m_122190_((Vec3i)pos);
                for (int i = 0; i < 1000 && level.m_46749_((BlockPos)currentPos); ++i) {
                    BlockState other1 = currentPos.equals((Object)pos) ? state : level.m_8055_((BlockPos)currentPos);
                    BlockState other2 = level.m_8055_(currentPos.m_121945_(connection));
                    boolean col1 = this.canConnect(state, other1);
                    boolean col2 = this.canConnect(state, other2);
                    currentPos.m_122173_(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = ConnectedPillarBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == this) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.m_183326_();
        if (!blockTicks.m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.m_60734_() != this) {
            return;
        }
        BlockPos belowPos = pPos.m_121945_(Direction.m_122387_((Direction.Axis)((Direction.Axis)pState.m_61143_((Property)f_55923_)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockState belowState = pLevel.m_8055_(belowPos);
        if (!this.canConnect(pState, belowState)) {
            pLevel.m_7731_(pPos, this.updateColumn((Level)pLevel, pPos, pState, true), 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!this.canConnect(state, pNeighborState)) {
            return ConnectedPillarBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.m_122434_() == state.m_61143_((Property)f_55923_)) {
            return this.m_152465_(pNeighborState);
        }
        return ConnectedPillarBlock.setConnection(state, pDirection, ConnectedPillarBlock.getConnection(pNeighborState, pDirection.m_122424_()));
    }

    protected boolean canConnect(BlockState state, BlockState other) {
        return other.m_60734_() == this && state.m_61143_((Property)f_55923_) == other.m_61143_((Property)f_55923_);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pIsMoving || pNewState.m_60734_() == this) {
            return;
        }
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)pState.m_61143_((Property)f_55923_))) {
            BlockPos relative = pPos.m_121945_(d);
            BlockState adjacent = pLevel.m_8055_(relative);
            if (!this.canConnect(pState, adjacent)) continue;
            pLevel.m_7731_(relative, this.updateColumn(pLevel, relative, adjacent, false), 3);
        }
    }

    public static boolean getConnection(BlockState state, Direction side) {
        BooleanProperty property = ConnectedPillarBlock.connection((Direction.Axis)state.m_61143_((Property)f_55923_), side);
        return property != null && (Boolean)state.m_61143_((Property)property) != false;
    }

    public static BlockState setConnection(BlockState state, Direction side, boolean connect) {
        BooleanProperty property = ConnectedPillarBlock.connection((Direction.Axis)state.m_61143_((Property)f_55923_), side);
        if (property != null) {
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    public static BooleanProperty connection(Direction.Axis axis, Direction side) {
        if (side.m_122434_() == axis) {
            return null;
        }
        if (axis == Direction.Axis.X) {
            switch (side) {
                case UP: {
                    return EAST;
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case DOWN: {
                    return WEST;
                }
            }
            return null;
        }
        if (axis == Direction.Axis.Y) {
            switch (side) {
                case EAST: {
                    return EAST;
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return null;
        }
        if (axis == Direction.Axis.Z) {
            switch (side) {
                case UP: {
                    return WEST;
                }
                case WEST: {
                    return SOUTH;
                }
                case EAST: {
                    return NORTH;
                }
                case DOWN: {
                    return EAST;
                }
            }
            return null;
        }
        return null;
    }
}

