/*
 * Decompiled with CFR 0.152.
 */
package com.cupboard.util;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class BlockSearch {
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR = (world, pos) -> world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_();
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_GROUND = this.DOUBLE_AIR.and((world, pos) -> world.m_8055_(pos.m_7495_()).m_280296_());

    public static BlockPos findAround(BlockGetter world, BlockPos start, int verticalRange, int horizontalRange, int yStep, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        int y = 0;
        int y_offset = yStep;
        boolean checkLoaded = world instanceof Level;
        Level level = checkLoaded ? (Level)world : null;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                temp.m_122178_(start.m_123341_() - steps, start.m_123342_() + y, start.m_123343_() - steps);
                for (x = 0; x <= steps; ++x) {
                    temp.m_122178_(temp.m_123341_() + 1, temp.m_123341_(), temp.m_123343_());
                    if (!(checkLoaded ? level.m_7232_(temp.m_123341_() >> 4, temp.m_123343_() >> 4) && predicate.test(world, (BlockPos)temp) : predicate.test(world, (BlockPos)temp))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    temp.m_122178_(temp.m_123341_(), temp.m_123342_(), temp.m_123343_() + 1);
                    if (!(checkLoaded ? level.m_7232_(temp.m_123341_() >> 4, temp.m_123343_() >> 4) && predicate.test(world, (BlockPos)temp) : predicate.test(world, (BlockPos)temp))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    temp.m_122178_(temp.m_123341_() - 1, temp.m_123342_(), temp.m_123343_());
                    if (!(checkLoaded ? level.m_7232_(temp.m_123341_() >> 4, temp.m_123343_() >> 4) && predicate.test(world, (BlockPos)temp) : predicate.test(world, (BlockPos)temp))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    temp.m_122178_(temp.m_123341_(), temp.m_123342_(), temp.m_123343_() - 1);
                    if (!(checkLoaded ? level.m_7232_(temp.m_123341_() >> 4, temp.m_123343_() >> 4) && predicate.test(world, (BlockPos)temp) : predicate.test(world, (BlockPos)temp))) continue;
                    return temp;
                }
            }
            y += y_offset;
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            y_offset *= -1;
        }
        return null;
    }
}

